// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Constraint/Malleable/hkpMalleableConstraintData.h>
#include <Physics/ConstraintSolver/Solve/hkpSolve.h>
#include <Physics/ConstraintSolver/Constraint/hkpConstraintQueryIn.h>
#include <Physics/ConstraintSolver/Constraint/Bilateral/hkp1dBilateralConstraintInfo.h>
#include <Physics2012/Internal/Solver/Atom/hkpBuildJacobianFromAtoms.h>
#include <Physics/Constraint/Data/hkpConstraintDataUtils.h>


hkpMalleableConstraintData::hkpMalleableConstraintData(hkpConstraintData* constraintData)
: hkpWrappedConstraintData(constraintData),
  m_strength(hkReal(0.01f))
{
    m_atoms.m_bridgeAtom.init( this );
}


void hkpMalleableConstraintData::afterReflectNew()
{
    m_atoms.m_bridgeAtom.init( this );
}

void hkpMalleableConstraintData::getConstraintInfo( hkpConstraintData::ConstraintInfo& info ) const
{
    // this must be called first otherwise clear()
    // gets called inside and erases the effect of previous
    // additions
    m_constraintData->getConstraintInfo(info);

    info.m_atoms = const_cast<hkpConstraintAtom*>(m_atoms.getAtoms());
    info.m_sizeOfAllAtoms = m_atoms.getSizeOfAllAtoms();
}


void hkpMalleableConstraintData::buildJacobian( const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out )
{
    hkpConstraintQueryIn min = in;

    min.m_virtMassFactor = min.m_virtMassFactor * m_strength;

    hkpConstraintData::ConstraintInfo info; m_constraintData->getConstraintInfo(info);
    hkSolverBuildJacobianFromAtoms( info.m_atoms, info.m_sizeOfAllAtoms, min, out );
}


void hkpMalleableConstraintData::setStrength(const hkReal tau)
{
    m_strength = tau;
}


hkReal hkpMalleableConstraintData::getStrength() const
{
    return m_strength;
}


int hkpMalleableConstraintData::getType() const
{
    return hkpConstraintData::CONSTRAINT_TYPE_MALLEABLE;
}

#if !defined(HK_PLATFORM_SPU)

hkpWrappedConstraintData* hkpMalleableConstraintData::deepClone() const
{
    // Clone wrapped constraint data
    const hkpConstraintData* srcChildData = getWrappedConstraintData();
    hkpConstraintData* dstChildData = hkpConstraintDataUtils::deepClone(srcChildData);

    // Clone breakable constraint
    hkpMalleableConstraintData* dstData = new hkpMalleableConstraintData(dstChildData);
    dstChildData->removeReference();

    // Copy members
    dstData->setStrength( getStrength() );
    return dstData;
}

#endif

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
