// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if !defined(HK_PLATFORM_SPU)
hkpSimpleContactConstraintData::~hkpSimpleContactConstraintData()
{
    if ( m_atom )
    {
        hkpSimpleContactConstraintAtomUtil::deallocateAtom(m_atom);
    }
}
#endif

#if !defined(HK_PLATFORM_SPU)
inline int hkpSimpleContactConstraintData::getNumContactPoints() const
{
    return m_atom->m_numContactPoints;
}
#endif

#if !defined(HK_PLATFORM_SPU)
hkContactPointId hkpSimpleContactConstraintData::getContactPointIdAt( int id ) const
{
    int rid = m_idMgrA.indexOf( id );
    return hkContactPointId( rid );

}
#endif

inline const hkContactPoint& hkpSimpleContactConstraintData::getContactPoint( int /*hkContactPointId*/ id ) const
{
    int index = m_idMgrA.getValueAt(id);
    HK_ASSERT( 0x456e434e, index != hkpDynamicsCpIdMgr::FREE_VALUE, "Invalid contact point");
    return HK_GET_LOCAL_CONTACT_ATOM(m_atom)->getContactPoints()[ index ];
}

inline hkContactPoint& hkpSimpleContactConstraintData::getContactPoint( int /*hkContactPointId*/ id )
{
    int index = m_idMgrA.getValueAt(id);
    HK_ASSERT( 0x456e434e, index != hkpDynamicsCpIdMgr::FREE_VALUE, "Invalid contact point");
    return HK_GET_LOCAL_CONTACT_ATOM(m_atom)->getContactPoints()[ index ];
}

inline hkpContactPointProperties* hkpSimpleContactConstraintData::getContactPointProperties( int /*hkContactPointId*/ id )
{
    int index = m_idMgrA.getValueAt(id);

    if ( index == hkpDynamicsCpIdMgr::FREE_VALUE )
    {
        return HK_NULL;
    }

    return HK_GET_LOCAL_CONTACT_ATOM(m_atom)->getContactPointPropertiesStream(index)->asProperties();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
