// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>

#include <Common/Base/Types/Physics/ContactPoint/hkContactPoint.h>
#include <Physics2012/Internal/Solver/Contact/hkpSimpleContactConstraintInfo.h>
#include <Physics2012/Dynamics/Constraint/Atom/hkpSimpleContactConstraintAtom.h>
#include <Physics2012/Dynamics/Constraint/Contact/hkpContactPointProperties.h>
#include <Physics2012/Dynamics/Constraint/Atom/hkpSimpleContactConstraintAtomUtil.h>
#include <Physics2012/Dynamics/Constraint/Contact/hkpDynamicsCpIdMgr.h>
#include <Physics2012/Dynamics/Constraint/hkpConstraintInstance.h>

class hkContactPoint;
class hkpSolverResults;
class hkpRigidBody;
class hkpSimpleConstraintContactMgr;


/// A group of simple contacts.
class HK_EXPORT_PHYSICS_2012 hkpSimpleContactConstraintData : public hkpConstraintData
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_CONTACT);

        inline ~hkpSimpleContactConstraintData();

            /// Get number of contact points.
        inline int getNumContactPoints() const;

            /// Get contactPoint at position i.
        inline hkContactPointId getContactPointIdAt( int index ) const;

            /// Get the contact point for an id.
        inline const hkContactPoint& getContactPoint( int /*hkContactPointId*/ id ) const;

            /// Get the contact point for an id.
        inline hkContactPoint& getContactPoint( int /*hkContactPointId*/ id );

            /// Get the result for the same id.
        inline hkpContactPointProperties* getContactPointProperties( int /*hkContactPointId*/ id );

        hkContactPointId allocateContactPoint( hkpConstraintOwner& constraintOwner, hkContactPoint** cpOut, hkpContactPointProperties** cpPropsOut);

            // return the new number of contact points
#if defined(HK_PLATFORM_SPU)
        HK_INLINE
#endif
        int freeContactPoint( hkpConstraintOwner& constraintOwner, hkContactPointId id );

        virtual hkBool isValid() const;

        // hkpConstraintData interface implementations
        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& infoOut ) const;

            // hkpConstraintData interface implementation
        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const;

        virtual hkpSolverResults* getSolverResults( hkpConstraintRuntime* runtime ) const;

        virtual int getType() const;

            /// This function is just called before a TOI or a normal collision response.
            /// Those collision response functions are called for every new contact point
            /// where the objects have a colliding velocity > hkpWorldCinfo.m_contactRestingVelocity
        virtual void collisionResponseBeginCallback( const hkContactPoint& cp, struct hkpSimpleConstraintInfoInitInput& inA, struct hkpBodyVelocity& velA, hkpSimpleConstraintInfoInitInput& inB, hkpBodyVelocity& velB );

        virtual void collisionResponseEndCallback( const hkContactPoint& cp, hkReal impulseApplied, struct hkpSimpleConstraintInfoInitInput& inA, struct hkpBodyVelocity& velA, hkpSimpleConstraintInfoInitInput& inB, hkpBodyVelocity& velB);

#if !defined(HK_PLATFORM_SPU)
            /// Returns a pointer to the containing contact manager.
        hkpSimpleConstraintContactMgr* getSimpleConstraintContactMgr() const;

    private:
            /// The constructor is private to ensure that objects of this class only ever exist as contained members
            /// of hkpSimpleConstraintContactMgr.
        hkpSimpleContactConstraintData(hkpConstraintInstance* constraint, hkpRigidBody* bodyA, hkpRigidBody* bodyB);
            /// Required for the constructor of hkpSimpleConstraintContactMgr.
        friend class hkpSimpleConstraintContactMgr;
#endif

    public:

        hkpDynamicsCpIdMgr      m_idMgrA;
        void*                   m_clientData;
        hkpConstraintInstance*  m_constraint;

        hkpSimpleContactConstraintAtom* m_atom;
        int                             m_atomSize; 
};

#include <Physics2012/Dynamics/Constraint/Contact/hkpSimpleContactConstraintData.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
