// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#if !defined(HK_PLATFORM_HAS_SPU)   // see HVK-3955
HK_INLINE hkpSimpleConstraintContactMgr* hkpContactImpulseLimitBreachedListenerInfo::getContactMgr() const
{
    const hkUlong offset = hkUlong(-HK_OFFSET_OF( hkpSimpleConstraintContactMgr, m_constraint ));
    return (hkpSimpleConstraintContactMgr*)hkAddByteOffset( m_data.m_single.m_constraintInstance, (hkLong)offset );
}
#endif

HK_INLINE hkpContactPointProperties *hkpContactImpulseLimitBreachedListenerInfo::getContactPointProperties() const
{
    if ( m_data.m_single.m_type != 0)
    {
        return m_data.m_single.m_properties;
    }
    return static_cast<hkpContactPointProperties*>( m_data.m_solver.m_solverResult );
}

HK_INLINE hkContactPoint *hkpContactImpulseLimitBreachedListenerInfo::getContactPoint() const
{
    if ( m_data.m_single.m_type != 0)
    {
        return m_data.m_single.m_contactPoint;
    }
    hkpSimpleConstraintContactMgr* mgr = getContactMgr();
    hkpSimpleContactConstraintAtom* atom = mgr->m_contactConstraintData.m_atom;
    const hkpContactPointPropertiesStream* cpp = reinterpret_cast<hkpContactPointPropertiesStream*>( m_data.m_solver.m_solverResult );
    hkUlong contactIndex = hkGetByteOffset(atom->getContactPointPropertiesStream(), cpp) / atom->getContactPointPropertiesStriding() ;
    hkContactPoint* cp = &atom->getContactPoints()[contactIndex];
    return cp;
}

HK_INLINE void hkpContactImpulseLimitBreachedListenerInfo::set(hkpConstraintInstance* constraintInstance, hkpContactPointProperties* properties, hkContactPoint* cp, bool toi)
{
    m_data.m_single.m_type = 1 + hkUint16(toi);
    m_data.m_single.m_isContact = true;
    m_data.m_single.m_constraintInstance = constraintInstance;
    m_data.m_single.m_contactPoint = cp;
    m_data.m_single.m_properties = properties;
}

HK_INLINE hkpRigidBody* hkpContactImpulseLimitBreachedListenerInfo::getBodyA() const
{
    return m_data.m_single.m_constraintInstance->getRigidBodyA();
}

HK_INLINE hkpRigidBody* hkpContactImpulseLimitBreachedListenerInfo::getBodyB() const
{
    return m_data.m_single.m_constraintInstance->getRigidBodyB();
}

HK_INLINE const hkpConstraintInstance* hkpContactImpulseLimitBreachedListenerInfo::getConstraintInstance() const
{
    return m_data.m_solver.m_constraintInstance;
}

HK_INLINE hkBool hkpContactImpulseLimitBreachedListenerInfo::isToi() const
{
    return m_data.m_single.m_type == 2;
}

HK_INLINE hkBool hkpContactImpulseLimitBreachedListenerInfo::isContact() const
{
    return m_data.m_solver.m_isContact == 1;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
