// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Constraint/hkpConstraintInstance.h>
#include <Physics2012/Dynamics/Collide/hkpSimpleConstraintContactMgr.h>

class hkpContactPointProperties;
class hkContactPointMaterial;


    /// Data used to identify breached contact points.
    /// This does not store any hkpShapeKey information.
    /// You have to retrieve the hkpShapeKey by using the userDataField in the hkContactPointMaterial structure
class HK_EXPORT_PHYSICS_2012 hkpContactImpulseLimitBreachedListenerInfo
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpContactImpulseLimitBreachedListenerInfo );

            /// Returns the contact mgr
        hkpSimpleConstraintContactMgr* getContactMgr() const;

            /// returns the array of all contact point properties
        hkpContactPointProperties* getContactPointProperties() const;

        hkContactPoint* getContactPoint() const;

        hkpRigidBody* getBodyA() const;

        hkpRigidBody* getBodyB() const;

        const hkpConstraintInstance* getConstraintInstance() const;

        void set( hkpConstraintInstance* constraintInstance, hkpContactPointProperties* properties, hkContactPoint* cp, bool isToi );

        hkBool isToi() const;

        hkBool isContact() const;

    protected:
        struct SingleImpulseElem
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpContactImpulseLimitBreachedListenerInfo::SingleImpulseElem );

            HK_ALIGN16(hkUint16             m_type);                // 1
            hkUint16 m_isContact;
            hkpConstraintInstance*          m_constraintInstance;
            hkpContactPointProperties*      m_properties;
            hkContactPoint*         m_contactPoint;
        };

        union ListenerData
        {
            HK_DECLARE_CLASS(ListenerData, NewOpaque);

            hkpImpulseLimitBreachedElem m_solver;
            SingleImpulseElem          m_single;
        };
        ListenerData m_data;
};

    /// This
class HK_EXPORT_PHYSICS_2012 hkpContactImpulseLimitBreachedListener
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpContactImpulseLimitBreachedListener);

        virtual ~hkpContactImpulseLimitBreachedListener(){}
        virtual void contactImpulseLimitBreachedCallback( const hkpContactImpulseLimitBreachedListenerInfo* breachedContacts, int numBreachedContacts ) = 0;
};

#include <Physics2012/Dynamics/Constraint/Contact/hkpContactImpulseLimitBreachedListener.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
