// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM       : ALL
// PRODUCT        : PHYSICS_2012
// VISIBILITY     : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/Constraint/Data/hkpConstraintData.h>

class hkpConstraintModifier;
class hkpConstraintMotor;
class hkGenericConstraintDataCinfo;



/// Ordered list of constraint construction commands and their parameters for the creation of a generic constraint
/// (hkpGenericConstraintData) through the constraint construction kit (hkpConstraintConstructionKit).
class HK_EXPORT_PHYSICS_2012 hkpGenericConstraintDataScheme
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpGenericConstraintDataScheme );

        // serialization workaround
        struct ConstraintInfo
        {
        public:
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpGenericConstraintDataScheme::ConstraintInfo );
            HK_DECLARE_REFLECTION();
            int m_maxSizeOfSchema;
            int m_sizeOfSchemas;
            int m_numSolverResults;
            int m_numSolverElemTemps;
        };

        HK_DECLARE_REFLECTION();

        hkpGenericConstraintDataScheme() {}

        enum
        {
            e_endScheme = 0,
            e_setPivotA, e_setPivotB,
            e_setLinearDofA, e_setLinearDofB, e_setLinearDofW, e_constrainLinearW, e_constrainAllLinearW,
            e_setAngularBasisA, e_setAngularBasisB, e_setAngularBasisAidentity, e_setAngularBasisBidentity,
            e_constrainToAngularW, e_constrainAllAngularW,e_setAngularMotor, e_setLinearMotor,
            e_setLinearLimit, e_setAngularLimit, e_setConeLimit, e_setTwistLimit, e_setAngularFriction, e_setLinearFriction,
            e_setStrength, e_restoreStrengh, e_doConstraintModifier,
            e_numCommands
        };

        struct HK_EXPORT_PHYSICS_2012 hkpConstraintInfo m_info; //+overridetype(struct hkpGenericConstraintDataScheme::ConstraintInfo) +nosave

        hkArray<hkVector4>              m_data;
        hkArray<int>                    m_commands;
        hkArray<hkpConstraintModifier*> m_modifiers; //+nosave
        hkArray<hkpConstraintMotor*>    m_motors;

    public:

        void afterReflectNew();
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
