// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainInstance.h>

#include <Physics2012/Dynamics/Action/hkpArrayAction.h>



class hkpEntity;


    /// Internal action only to be used by hkpConstraintChainInstance. It assures proper logical linking of all the entities connected by a hkpConstraintChainInstance.
class HK_EXPORT_PHYSICS_2012 hkpConstraintChainInstanceAction : public hkpAction
{
    public:
        HK_DECLARE_CLASS(hkpConstraintChainInstanceAction, New, Reflect, BypassCtor);

        friend class hkpConstraintChainInstance;

            /// Default ctor. Only to be run from the hkpConstraintChainInstance ctor.
        hkpConstraintChainInstanceAction(hkpConstraintChainInstance* chain) : hkpAction(0)
        {
            m_constraintInstance = chain;
            // we don't add reference. This object belongs to the chain instance.

            HK_ASSERT(0xad78855d, m_constraintInstance->m_chainedEntities.getSize() == 0, "hkpConstraintChainInstanceAction can only be created in the constructor of hkpConstraintChainInstance.");
        }

    public:

            /// Dtor.
        virtual ~hkpConstraintChainInstanceAction()
        {
        }
            /// Interface implementation.
        virtual void applyAction( const hkStepInfo& stepInfo );

            /// Interface implementation. Cloning is not supported.
        virtual hkpAction* clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const;

            /// Interface implementation.
        virtual void entityRemovedCallback(hkpEntity* entity);

            /// Returns the constraint chain instance that this action belongs to.
        inline hkpConstraintChainInstance* getConstraintInstance() { return m_constraintInstance; }

            /// Gets the action's entities. This function references the entity array stored in the constraint chain.
        virtual void getEntities( hkArray<hkpEntity*>& entitiesOut );

    public:

            /// The constraint chain instance that this action belongs to.
        hkViewPtr<class hkpConstraintChainInstance> m_constraintInstance;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
