// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainInstanceAction.h>

#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Dynamics/World/Util/hkpWorldOperationUtil.h>

void hkpConstraintChainInstanceAction::applyAction( const hkStepInfo& stepInfo )
{
    /// Just make sure the action was properly added to the world together with the constraint chain.
    HK_ASSERT(0xad5677dd, getConstraintInstance()->getOwner() != HK_NULL, "Constraint was not added to the world.");
}

hkpAction* hkpConstraintChainInstanceAction::clone( const hkArray<hkpEntity*>& newEntities, const hkArray<hkpPhantom*>& newPhantoms ) const
{
    HK_ASSERT(0xad7765dd, false, "Cloning of hkpConstraintChainInstanceAction not supported.");
    return HK_NULL;
}

void hkpConstraintChainInstanceAction::entityRemovedCallback(hkpEntity* entity)
{
    HK_ASSERT_NO_MSG(0xad000227, getWorld() );
        // Call the constraint's callback, which in turn will immeidately remove this action from the world
    getConstraintInstance()->entityRemovedCallback(entity);
}


void hkpConstraintChainInstanceAction::getEntities( hkArray<hkpEntity*>& entitiesOut )
{
    entitiesOut = getConstraintInstance()->m_chainedEntities;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
