// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainInstance.h>
#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainInstanceAction.h>

#include <Physics2012/Dynamics/World/hkpWorld.h>
#include <Physics2012/Dynamics/World/Util/hkpWorldOperationUtil.h>

hkpConstraintChainInstance::hkpConstraintChainInstance(hkpConstraintChainData* data)
: hkpConstraintInstance(PRIORITY_PSI)
{
    HK_ASSERT(0xad675544, data->getType() >= hkpConstraintData::BEGIN_CONSTRAINT_CHAIN_TYPES, "You're passing a non-chain-constraint data to a hkpConstraintChainInstance's ctor.");

    m_data = data;
    data->addReference();

    m_entities[0] = HK_NULL;
    m_entities[1] = HK_NULL;

    m_action = new hkpConstraintChainInstanceAction(this);

    m_chainConnectedness = 0;
}


void hkpConstraintChainInstance::addEntity(hkpEntity* entity)
{
    HK_ASSERT(0xad6d5d44, m_owner == HK_NULL, "Cannot add entities when constraint chain is added to the world");

    if (m_chainedEntities.getSize() < 2 )
    {
        const int idx = m_chainedEntities.getSize();
        HK_ASSERT(0xad6888d0, m_entities[idx] ==  HK_NULL || m_entities[idx] == entity, "First or second entity added is different from that passed in the hkpConstraintChainInstance's constructor.");
        if (m_entities[idx] == HK_NULL)
        {
            m_entities[idx] = entity;
            entity->addReference();
        }
    }

    m_chainedEntities.pushBack( entity );
    entity->addReference();
}


void hkpConstraintChainInstance::rebuildBaseEntities()
{
    hkpEntity* eA = m_chainedEntities.getSize() > 0 ? m_chainedEntities[0] : HK_NULL;
    hkpEntity* eB = m_chainedEntities.getSize() > 1 ? m_chainedEntities[1] : HK_NULL;
    if (m_entities[0] != eA )
    {
        if (eA )
        {
            eA->addReference();
        }
        if ( m_entities[0])
        {
            m_entities[0]->removeReference();
        }
        m_entities[0] = eA;
    }
    if (m_entities[1] != eB )
    {
        if (eB )
        {
            eB->addReference();
        }
        if ( m_entities[1])
        {
            m_entities[1]->removeReference();
        }
        m_entities[1] = eB;
    }
}

hkpEntity* hkpConstraintChainInstance::removeEntity(int index)
{
    hkpEntity* body = m_chainedEntities[index];
    HK_ASSERT(0xad6d5d44, m_owner == HK_NULL, "Cannot remove entities when constraint chain is added to the world");

    m_chainedEntities.removeAtAndCopy(index);
    if ( index<2)
    {
        rebuildBaseEntities();
    }
    body->removeReference();
    return body;
}

void hkpConstraintChainInstance::insertEntityAtFront(hkpEntity* entity, int index )
{
    HK_ASSERT(0xad6d5d44, m_owner == HK_NULL, "Cannot add entities when constraint chain is added to the world");
    HK_ASSERT(0xad7877dd, m_chainedEntities.getSize() <= getData()->getNumConstraintInfos(), "Cannot add anymore entities to the chain -- pivots not specified.");
    m_chainedEntities.insertAt( index, entity );
    if ( index < 2 )
    {
        rebuildBaseEntities();
    }
    entity->addReference();
}

hkpConstraintChainInstance::~hkpConstraintChainInstance()
{
    for (int i = 0; i < m_chainedEntities.getSize(); i++)
    {
        m_chainedEntities[i]->removeReference();
    }

    if( m_action )
    {
        HK_ASSERT(0xad78dd33, m_action->getWorld() == HK_NULL && m_action->getReferenceCount() <= 1, "hkpConstraintChainInstanceAction's lifetime cannot exceed that of its hkpConstraintChainInstance.");
        m_action->removeReference();
    }
}

void hkpConstraintChainInstance::entityRemovedCallback(hkpEntity* entity)
{
    // before checkin, make sure that this assert is ok ?
    HK_ASSERT(0xad6777dd, m_owner != HK_NULL, "internal error.");

    HK_ASSERT(0xad4bd4d3, entity->getWorld(), "Internal error: entity passed in hkpConstraintInstance::entityRemovedCallback is already removed from the world (Constraints must be removed first).");
    hkpWorld* world = entity->getWorld();

    world->lockCriticalOperations();
    {
        // Adding constraint chain's action
        world->removeActionImmediately(m_action);

        // info: locking done in the hkpWorldOperationUtil function
        hkpWorldOperationUtil::removeConstraintFromCriticalLockedIsland(world, this);

    }
    world->unlockAndAttemptToExecutePendingOperations();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
