// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics/ConstraintSolver/Solve/hkpSolverResults.h>
#include <Physics/Constraint/Atom/Bridge/hkpBridgeConstraintAtom.h>
#include <Physics2012/Dynamics/Constraint/Chain/hkpConstraintChainData.h>
#include <Physics2012/Dynamics/Action/hkpArrayAction.h>

    /// A chain of ball-and-socket constraints. Useful for creating ropes or hanging bridges.
class HK_EXPORT_PHYSICS_2012 hkpBallSocketChainData : public hkpConstraintChainData
{
    //+version(2)
    public:

        HK_DECLARE_REFLECTION();

        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_CONSTRAINT); // and action too

        hkpBallSocketChainData();

            /// Not implemented. Returns always true.
        hkBool isValid() const { return true; }

            /// Get type from this constraint
        virtual int getType() const;

            /// Returns the number of stored constraint infos.
        virtual int getNumConstraintInfos() { return m_infos.getSize(); }

            /// Adds a constraint info to the chain.
            /// Pivot points are specified in the local space of the bodies.
            /// if idx >=0 than idx will be used to define the insert position
        void addConstraintInfoInBodySpace(const hkVector4& pivotInA, const hkVector4& pivotInB, int idx = -1 );

            /// Enables/disables stabilized code. Must be called when the constraint is not in the world.
        void useStabilizedCode(bool useIt);

    public:

        struct Runtime
        {
                /// Runtime only stores solver results. The number of solver results is (hkpBallAndSocketConstraintData::SOLVER_RESULT_MAX * getNumConstraintInfos()
                /// == 3 * getNumConstraintInfos()).
                /// Note: when the instance uses less constraints than there are constraintInfos, then the hkpSolverResults at the end of the array are uninitialized.
            inline const hkpSolverResults* getSolverResults() const { return reinterpret_cast<const hkpSolverResults*>(this); }
        };

        inline static const Runtime* getRuntime( const hkpConstraintRuntime* runtime )
        {
            return reinterpret_cast<const Runtime*>(runtime);
        }

        inline static Runtime* getRuntime( hkpConstraintRuntime* runtime )
        {
            return reinterpret_cast<Runtime*>(runtime);
        }

    public:

        //
        // Internal functions
        //

            /// Interface implementation.
        virtual void buildJacobian( const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out );

            /// Builds normal unstabilized jacobians, solving matrices here. And reuses them during solving.
        void buildJacobian_Unstabilized( const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out );

            /// Builds information data for stabilized constraints. When solving, jacobians and solving matrices
            /// are rebuild every solver step.
        void buildJacobian_Stabilized( const hkpConstraintQueryIn &in, hkpConstraintQueryOut &out );

            /// Interface implementation.
        virtual void getConstraintInfo( hkpConstraintData::ConstraintInfo& info ) const;

            /// Interface implementation.
        virtual void getRuntimeInfo( hkBool wantRuntime, hkpConstraintData::RuntimeInfo& infoOut ) const;

    public:

        void afterReflectNew();

    public:

        struct hkpBridgeAtoms m_atoms;

            /// This structure holds information needed for an individual constraint in the chain.
        struct ConstraintInfo
        {
            //+version(1)
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_DYNAMICS, hkpBallSocketChainData::ConstraintInfo );
            HK_DECLARE_REFLECTION();

                /// Constraint's pivot point in bodyA's space.
            hkVector4 m_pivotInA;

                /// Constraint's pivot point in bodyB's space.
            hkVector4 m_pivotInB;

                /// flags, see hkpPoweredBallSocketChainFlags::Enum (can't use it because of client visibility)
            hkUint32 m_flags;
        };

            /// Constraint infos for the chain's constraints.
        hkArray<struct ConstraintInfo> m_infos;

            /// The velocity in world space of pivot B of constraint 0, this is needed by the segmented rope to shorten ropes
            /// gradually.
        hkVector4 m_link0PivotBVelocity;

            /// Solver tau, this overrides the global value from hkpSolverInfo when processing the chained constraints.
        hkReal m_tau;

            /// Solver damping, this overrides the global value from hkpSolverInfo when processing the chained constraints.
        hkReal m_damping;

            /// Constraint force mixing parameter. Value added to the diagonal of the constraint matrix.
            /// Should be zero or tiny, e.g., a fraction of HK_REAL_EPSILON. When this value is zero, then some chain configurations
            /// may result in a division by zero when solving.
        hkReal m_cfm;

            /// Specifies the maximum distance error in constraints allowed before the stabilization algorithm kicks in.
            /// The algorithm eliminates explosions in may cases, but due to its nature it yields incorrect results in certain use cases.
            /// It is disabled by default.
        hkReal m_maxErrorDistance;

            /// Helper variable to control high oscillation frequencies. The higher the value, the more stable the rope,
            /// but also the higher the artifacts. A good value is between 5 and 50;
        hkReal m_inertiaPerMeter;  //+default(20)

    private:
            /// Choose to use stabilized ball-socket code. This results in jacobians and the solving matrices being
            /// recalculated every solver step.
        bool m_useStabilizedCode;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
