// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//
// breakable constraint methods
//
inline void hkpBreakableConstraintData::setThreshold(hkReal thresh)
{
    m_solverResultLimit = thresh;
}

inline hkReal hkpBreakableConstraintData::getThreshold() const
{
    return m_solverResultLimit;
}

inline void hkpBreakableConstraintData::setRemoveWhenBroken(hkBool tf)
{
    m_removeWhenBroken = tf;
}

inline hkBool hkpBreakableConstraintData::getRemoveWhenBroken() const
{
    return m_removeWhenBroken;
}

inline void hkpBreakableConstraintData::setRevertBackVelocityOnBreak( hkBool b )
{
    m_revertBackVelocityOnBreak = b;
}


inline hkBool hkpBreakableConstraintData::getRevertBackVelocityOnBreak() const
{
    return m_revertBackVelocityOnBreak;
}


inline hkpBreakableConstraintData::Runtime* hkpBreakableConstraintData::getRuntime( hkpConstraintRuntime* runtime )
{
    return reinterpret_cast<Runtime*>( hkAddByteOffset(runtime, m_childRuntimeSize));
}

inline hkBool hkpBreakableConstraintData::getIsBroken(const hkpConstraintInstance* instance)
{
    HK_ASSERT(0x34322884, instance != HK_NULL, "Null instance pointer passed to getIsBroken");
    Runtime* runtime = getRuntime( instance->getRuntime() );
    HK_ASSERT(0x34322883, runtime != HK_NULL, "Runtime must be non-null. This constraint may not be added to the world.");
    return runtime->m_isBroken;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
