// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hkpMaterial::hkpMaterial()
:   m_friction( 0.5f ),
    m_restitution( 0.4f )
{
    m_rollingFrictionMultiplier.setZero();
}

inline hkReal hkpMaterial::getFriction() const
{
    return m_friction;
}

inline hkReal hkpMaterial::getRestitution() const
{
    return m_restitution;
}

inline hkReal hkpMaterial::getRollingFrictionMultiplier() const
{
    return m_rollingFrictionMultiplier.getReal();
}

inline void hkpMaterial::setFriction( hkReal newFriction )
{
    HK_ASSERT( 0xf0160299, newFriction>=0.0f && newFriction <= 255.0f, "Friction value out of range" );
    m_friction = newFriction;
}

inline void hkpMaterial::setRestitution( hkReal newRestitution )
{
    HK_ASSERT( 0xf0160256, newRestitution >= 0.0f && newRestitution < 1.99f, "Restitution value out of range" );
    m_restitution = newRestitution;
}

inline void hkpMaterial::setRollingFrictionMultiplier( hkReal newRollingFrictionMultiplier )
{
    m_rollingFrictionMultiplier.setReal<true>(newRollingFrictionMultiplier);
}


inline hkReal HK_CALL hkpMaterial::getCombinedFriction( hkReal frictionA, hkReal frictionB )
{
    return hkMath::sqrt( frictionA * frictionB );
}

inline hkReal HK_CALL hkpMaterial::getCombinedRestitution( hkReal restitutionA, hkReal restitutionB )
{
    return hkMath::sqrt( restitutionA * restitutionB );
}

inline hkReal HK_CALL hkpMaterial::getCombinedRollingFrictionMultiplier( hkReal multiplierA, hkReal multiplierB )
{
    
    return hkMath::max2( multiplierA, multiplierB );
}

inline void hkpMaterial::setResponseType( enum hkpMaterial::ResponseType t )
{
    m_responseType = t;
}

inline enum hkpMaterial::ResponseType hkpMaterial::getResponseType() const
{
    return m_responseType;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
