// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/OStream/hkOStream.h>

    /// This class is used to debug the internal core of Havok.
    /// This class in not intended to be used by clients yet.
class HK_EXPORT_PHYSICS_2012 hkTraceStream : public hkReferencedObject
{
    public:
        HK_DECLARE_CLASS(hkTraceStream, New, Singleton);

        struct HK_EXPORT_PHYSICS_2012 Title
        {
            HK_DECLARE_CLASS(Title, New, Reflect );
            HK_RECORD_ATTR( hk::Serialize(false) );

            Title() { m_value[0] = 0; }
            Title(const char* value)
            {
                HK_ASSERT(0xf0ff0090, hkString::strLen(value) < 32, "Error in debugging utils: title cannot exceed 31 characters.");
                hkString::strNcpy(m_value, value, 31);
            }

            char m_value[32];
        };


            // disable all printf with a given title.
        void disableTitle( const char* title ) { m_titles.pushBack( Title(title) ); }

            // enable all printf with a given title.
        //void enableTitle( const char* title )  { }

            // reset the traceStream
        void reset();

            // print a debug line with a given title
        void printf( const char* title, const char* fmt, ... );

    public:

        hkTraceStream() { m_stream = HK_NULL; m_counter = 0; }

            /// Needed to create a new vtbl
        //virtual ~hkTraceStream() {}

    public:

        hkOstream* m_stream HK_ATTR( hk::Reflect(false) );
        int        m_counter;

        hkArray<struct Title> m_titles;

};

#ifdef HK_DEBUG
//# define HK_DEBUG_TOI "debugToi.txt"
#endif

#if defined HK_DEBUG_TOI
#   define hkToiPrintf hkTraceStream::getInstance().printf
#   define hkDebugToi 1
#else
#   define hkToiPrintf
#   define hkDebugToi 0
#endif

#define HK_IS_TRACE_ENABLED(A, B) true

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
