// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Common/TraceStream/hkTraceStream.h>
#include <Common/Base/Object/hkSingleton.h>

HK_SINGLETON_IMPLEMENTATION(hkTraceStream);

#if defined HK_DEBUG_TOI

#include <Common/Base/Fwd/hkcstdarg.h>

using namespace std;

static const int HK_TRACE_STREAM_MAX_STRING_SIZE = 1024;

void hkTraceStream::printf( const char* title, const char* fmt, ... )
{
    // break if title is not supported
    {
        for (int i = 0; i < m_titles.getSize(); i++)
        {
            if (0 == hkString::strCmp(m_titles[i].m_value, title))
            {
                //don't display this message
                return;
            }
        }
    }

    m_counter++;
    if ( m_counter == 2051)
    {
        // place your breakpoint here:
        m_counter *= 1;
    }

    if ( m_stream )
    {
        char buf[HK_TRACE_STREAM_MAX_STRING_SIZE];
        //
        //  output line number
        //
        va_list args;
        va_start(args, fmt);

        if ( fmt[0] == '#')
        {
            hkString::sprintf( buf, "%4i\t\t", m_counter );
            m_stream->write(buf, hkString::strLen( buf ) );
            hkString::vsnprintf(buf, HK_TRACE_STREAM_MAX_STRING_SIZE, fmt+1, args);
        }
        else
        {
            hkString::vsnprintf(buf, HK_TRACE_STREAM_MAX_STRING_SIZE, fmt, args);
        }
        va_end(args);
        m_stream->write(buf, hkString::strLen( buf ) );
    }
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
