// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Common/SmallArray/hkSmallArray.h>
#include <Common/Base/Memory/Util/hkMemUtil.h>

using namespace std;

// Check size
HK_COMPILE_TIME_ASSERT( sizeof(void*)==sizeof(char*) );

// hack to force this to be out of line
void hkSmallArrayUtil::_reserve(void* array, int numElem, int sizeElem)
{
    HK_ASSERT(0x3b67c014, numElem >= 0, "Number of elements must not be negative");
    HK_ASSERT(0x243bf8d1, sizeElem >= 0, "The size of an element must not be negative");

    typedef hkSmallArray<char> hkAnyArray;

    char* p = hkAllocateChunk<char>(numElem*sizeElem, HK_MEMORY_CLASS_ARRAY);
    hkAnyArray* self = reinterpret_cast< hkAnyArray* >(array);
    hkMemUtil::memCpy(p, self->m_data, self->m_size*sizeElem);
    //cannot call self->releaseMemory(), because we're lying about the size of each element.
    if( (self->m_capacityAndFlags & hkAnyArray::DONT_DEALLOCATE_FLAG) == 0)
    {
        hkDeallocateChunk<char>( self->m_data, self->getCapacity()*sizeElem, HK_MEMORY_CLASS_ARRAY);
    }

    self->m_data = p;
    self->m_capacityAndFlags = hkUint16( numElem | (self->m_capacityAndFlags & hkAnyArray::LOCKED_FLAG)); // prop the locked flag? (even though we have realloced..)
}

// hack to force this to be out of line
void hkSmallArrayUtil::_reserveMore(void* array, int sizeElem)
{
    HK_ASSERT(0x5828d5cf, sizeElem >= 0, "The size of an element must not be negative");

    typedef hkSmallArray<char> hkAnyArray;
    hkAnyArray* self = reinterpret_cast< hkAnyArray* >(array);
    int numElem = hkMath::clamp(self->m_size * 2, 1, hkSmallArray<void*>::CAPACITY_MASK);
    if (numElem <= self->m_size)
    {
        HK_ERROR(0x3017785c, "hkSmallArray maximum capacity reached");
        return;
    }

    char* p = hkAllocateChunk<char>(numElem*sizeElem, HK_MEMORY_CLASS_ARRAY);
    hkMemUtil::memCpy(p, self->m_data, self->m_size*sizeElem);
    //cannot call self->releaseMemory(), because we're lying about the size of each element.
    if( (self->m_capacityAndFlags & hkAnyArray::DONT_DEALLOCATE_FLAG) == 0)
    {
        hkDeallocateChunk<char>( self->m_data, self->getCapacity()*sizeElem, HK_MEMORY_CLASS_ARRAY);
    }

    self->m_data = p;
    self->m_capacityAndFlags = hkUint16(numElem | (self->m_capacityAndFlags & hkAnyArray::LOCKED_FLAG)); // prop the locked flag? (even though we have realloced..)
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
