// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/Constraint/Atom/hkpModifierConstraintAtom.h>

hkUint16 HK_CALL hkpResponseModifier::getAdditionalSchemaSize( hkUint8 flags )
{
    hkUint16 additionalSchemaSize = tableOfAdditionalSchemaSizes[ flags & ADDITIONAL_SIZE_MODIFIERS ];
#ifdef HK_DEBUG
    hkUint16 schemaSize = 0;

    if ( flags & MASS_SCALING )
    {
        schemaSize += hkpMassChangerModifierConstraintAtom::ADDITIONAL_SCHEMA_SIZE;
    }
    if ( flags & CENTER_OF_MASS_DISPLACEMENT )
    {
        schemaSize += hkpCenterOfMassChangerModifierConstraintAtom::ADDITIONAL_SCHEMA_SIZE;
    }
    if ( flags & SURFACE_VELOCITY )
    {
        schemaSize += hkpMovingSurfaceModifierConstraintAtom::ADDITIONAL_SCHEMA_SIZE;
    }
    if ( flags & IMPULSE_SCALING )
    {
        schemaSize += hkpSoftContactModifierConstraintAtom::ADDITIONAL_SCHEMA_SIZE;
    }
    if ( flags & VISCOUS_SURFACE )
    {
        schemaSize += hkpViscousSurfaceModifierConstraintAtom::ADDITIONAL_SCHEMA_SIZE;
    }
    HK_ASSERT( 0x45f518e3, schemaSize == additionalSchemaSize, "The look-up table is out of date." );
#endif //HK_DEBUG
    return additionalSchemaSize;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
