// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Agent/ContactMgr/hkpContactMgr.h>

class hkContactPoint;
class hkpContactPointProperties;


///An interface to access contact point information.
class HK_EXPORT_PHYSICS_2012 hkpDynamicsContactMgr: public hkpContactMgr
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        hkpDynamicsContactMgr( Type type ): hkpContactMgr( type ) {}

            /// Gets the properties attached to the contact point (if available)
        virtual hkpContactPointProperties* getContactPointProperties( hkContactPointId id ){ return HK_NULL;}

            /// Gets the dynamics contact point (if available)
        virtual hkContactPoint* getContactPoint( hkContactPointId id ){ return HK_NULL;}

            /// Gets the ids of all contact points in this collision
        virtual void getAllContactPointIds( hkArray<hkContactPointId>& contactPointIds ) const {}

        virtual Type getType() const = 0;

            /// Virtual function which is called just before a simple collision response is executed
            /// in a TOI. The default implementation will forward this to the hkpSimpleContactConstraintData::collisionResponseBeginCallback.
            /// This is used for the mass changer and moving surface utility
        virtual void toiCollisionResponseBeginCallback( const hkContactPoint& cp, struct hkpSimpleConstraintInfoInitInput& inA, struct hkpBodyVelocity& velA, hkpSimpleConstraintInfoInitInput& inB, hkpBodyVelocity& velB){}

            /// Virtual function which is called just after a simple collision response is executed.
            /// The default implementation will forward this to the hkpSimpleContactConstraintData::collisionResponseEndCallback.
            /// This is used for the mass changer and moving surface utility
        virtual void toiCollisionResponseEndCallback( const hkContactPoint& cp, hkReal impulseApplied, struct hkpSimpleConstraintInfoInitInput& inA, struct hkpBodyVelocity& velA, hkpSimpleConstraintInfoInitInput& inB, hkpBodyVelocity& velB){}

            /// Return the constraint if there is one
        virtual class hkpConstraintInstance* getConstraintInstance() { return HK_NULL; }

            /// Fire contactPointCallbacks when the earliest TOI callback has been identified.
            /// \return True if the TOI should be processed.
        virtual hkBool fireCallbacksForEarliestToi( struct hkpToiEvent& event, hkReal& rotateNormal ) { return false; }

            /// Apply custom TOI-collision handling before localized solving; this method actually belongs to hkpDynamicsContactMgr interface.
        virtual void confirmToi( struct hkpToiEvent& event, hkReal rotateNormal, class hkArray<class hkpEntity*>& outToBeActivated ){}

    protected:
        class hkpWorld*                 m_world;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
