// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/Entity/Util/hkpEntityCallbackUtil.h>
#include <Physics2012/Dynamics/World/Util/hkpWorldCallbackUtil.h>

#if defined (HK_PLATFORM_SPU)
#include <Physics2012/Dynamics/Collide/Deprecated/Dispatch/hkpSpuCollisionCallbackUtil.h>
#endif

void HK_CALL hkFireContactPointAddedCallback(hkpWorld* world, hkpEntity* entityA, hkpEntity* entityB, hkpContactPointAddedEvent& event)
{
#if !defined (HK_PLATFORM_SPU)
    {
        hkpWorldCallbackUtil ::fireContactPointAdded( world,   event );
        hkpEntityCallbackUtil::fireContactPointAdded( entityA, event );
        hkpEntityCallbackUtil::fireContactPointAdded( entityB, event );
    }
#else
    if( g_FireContactPointAddedCallback )
    {
        g_FireContactPointAddedCallback( entityA, entityB, event );
    }
#endif
}

void HK_CALL hkFireContactProcessCallback(hkpWorld* world, hkpEntity* entityA, hkpEntity* entityB, hkpContactProcessEvent& event)
{
#if !defined (HK_PLATFORM_SPU)
    {
        hkpWorldCallbackUtil ::fireContactProcess( world,   event );
        hkpEntityCallbackUtil::fireContactProcess( entityA, event );
        hkpEntityCallbackUtil::fireContactProcess( entityB, event );
    }
#else
    if( g_FireContactProcessCallback )
    {
        g_FireContactProcessCallback( entityA, entityB, event );
    }
#endif
}

void HK_CALL hkFireContactPointRemovedCallback(hkpWorld* world, hkpEntity* entityA, hkpEntity* entityB, hkpContactPointRemovedEvent& event)
{
#if !defined (HK_PLATFORM_SPU)
    {
        hkpWorldCallbackUtil ::fireContactPointRemoved( world,   event );
        hkpEntityCallbackUtil::fireContactPointRemoved( entityA, event );
        hkpEntityCallbackUtil::fireContactPointRemoved( entityB, event );
    }
#else
    if( g_FireContactPointRemovedCallback )
    {
        g_FireContactPointRemovedCallback( entityA, entityB, event );
    }
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
