// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#if !defined( HK_PLATFORM_SPU )
#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactPointEvent.h>
#include <Physics2012/Dynamics/Collide/ContactListener/hkpCollisionEvent.h>
#endif

#include <Physics2012/Dynamics/Collide/Deprecated/hkpCollisionEvents.h>

    /// The interface for listeners that respond to contact events.
class HK_EXPORT_PHYSICS_2012 hkpContactListener
{
    public:
        HK_DECLARE_CLASS(hkpContactListener, New, ReflectVirtualBase);
        HK_RECORD_ATTR(hk::Serialize(false));

        //
        // Contact point events.
        //

            /// This is called for each new contact point between two bodies. It will
            /// also be called for all contact points in the contact manifold when the
            /// hkpSimpleConstraintContactMgr's m_contactPointCallbackDelay value
            /// reaches zero.
        virtual void contactPointCallback( const hkpContactPointEvent& event ) {}

        //
        // Collision events.
        //
        // If hkpWorldCinfo.m_fireCollisionCallbacks is set to true, then these are fired when
        // the constraint representing the collision is added or removed from the world.
        //
        // These callbacks are fired single-threaded but not necessarily in deterministic order.
        //
        // Note that a collisionAddedCallback does not guarantee that a collision has occurred if a
        // collisionRemovedCallback is also fired in the same frame. (Of course, contactPointEvents
        // will be fired if a collision did occur during the frame).
        //

            /// Called for a new collision between two bodies.
        virtual void collisionAddedCallback( const hkpCollisionEvent& event ) {}

            /// Called when two bodies are no longer colliding.
        virtual void collisionRemovedCallback( const hkpCollisionEvent& event ) {}

        //
        // If you want to receive contactPointCallbacks of TYPE_MANIFOLD_AT_END_OF_STEP, you should
        // use these methods to register and unregister the collision.
        //

            /// Call this from a collisionAddedCallback to receive the extra contactPointCallbacks.
        void registerForEndOfStepContactPointCallbacks( const hkpCollisionEvent& event );

            /// Call this from a collisionRemovedCallback to unregister.
        void unregisterForEndOfStepContactPointCallbacks( const hkpCollisionEvent& event );

            /// Destructor.
        virtual ~hkpContactListener() {}

    public:

        //
        // Deprecated callbacks which support the old hkpCollisionListener interface.
        //

        virtual void contactPointAddedCallback( hkpContactPointAddedEvent& event) {}
        virtual void contactPointRemovedCallback( hkpContactPointRemovedEvent& event ) {}
        virtual void contactProcessCallback( hkpContactProcessEvent& event ) {}
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
