// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Collide/ContactListener/hkpContactListener.h>
#include <Physics2012/Dynamics/Collide/ContactListener/Util/hkpCollisionCallbackUtil.h>
#include <Physics2012/Dynamics/Collide/ContactListener/Util/hkpEndOfStepCallbackUtil.h>

void hkpContactListener::registerForEndOfStepContactPointCallbacks( const hkpCollisionEvent& event )
{
    const hkpWorld* world = event.m_bodies[0]->getWorld();
    hkpCollisionCallbackUtil* collisionCallbackUtil = hkpCollisionCallbackUtil::findCollisionCallbackUtil( world );
    HK_ASSERT( 0x47feba2, collisionCallbackUtil, "You must set hkpWorldCinfo::m_fireCollisionCallbacks to register a collision for end of step callbacks" );
    collisionCallbackUtil->m_endOfStepCallbackUtil.registerCollision( event.m_contactMgr, this, event.m_source );
}


void hkpContactListener::unregisterForEndOfStepContactPointCallbacks( const hkpCollisionEvent& event )
{
    const hkpWorld* world = event.m_bodies[0]->getWorld();
    hkpCollisionCallbackUtil* collisionCallbackUtil = hkpCollisionCallbackUtil::findCollisionCallbackUtil( world );
    HK_ASSERT( 0x47feba2, collisionCallbackUtil, "You must set hkpWorldCinfo::m_fireCollisionCallbacks to unregister a collision for end of step callbacks" );
    collisionCallbackUtil->m_endOfStepCallbackUtil.unregisterCollision( event.m_contactMgr, this, event.m_source );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
