// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

hkpRigidBody* hkpCollisionEvent::getBody( int bodyIdx ) const
{
    HK_ASSERT( 0x4e66ea80, bodyIdx == 0 || bodyIdx == 1, "The bodyIdx must be 0 or 1." );
    return m_bodies[bodyIdx];
}

hkpCollisionEvent::hkpCollisionEvent( CallbackSource source, hkpRigidBody* bodyA, hkpRigidBody* bodyB, hkpSimpleConstraintContactMgr* mgr )
: m_source( source ), m_contactMgr( mgr )
{
    m_bodies[0] = bodyA;
    m_bodies[1] = bodyB;
}

hkpSimulationIsland* hkpCollisionEvent::getSimulationIsland() const
{
    // There should be no event in which both entities are fixed.
    hkpSimulationIsland* island = m_bodies[0]->getSimulationIsland();
    if ( island->isFixed() )
    {
        island = m_bodies[1]->getSimulationIsland();
    }
    return island;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
