// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>
#include <Physics2012/Dynamics/World/hkpSimulationIsland.h>
class hkpSimpleConstraintContactMgr;

/// An event recording the start or end of a collision between two bodies.
class HK_EXPORT_PHYSICS_2012 hkpCollisionEvent
{
    public:
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE,hkpCollisionEvent);
            /// Determines the participant to which a listener was attached.
        enum CallbackSource
        {
            SOURCE_A = 0,
            SOURCE_B = 1,
            SOURCE_WORLD
        };

    public:
            /// Constructor.
        inline hkpCollisionEvent( CallbackSource source, hkpRigidBody* bodyA, hkpRigidBody* bodyB, hkpSimpleConstraintContactMgr* mgr );

            /// Returns the first or second rigid body.
        inline hkpRigidBody* getBody( int bodyIdx ) const;

            /// Returns the simulation island (i.e., the constraint owner) containing this contact.
        inline hkpSimulationIsland* getSimulationIsland() const;

    public:

        CallbackSource m_source;

            /// The rigid bodies.
        hkpRigidBody* m_bodies[2];

            /// The contact manager.
        hkpSimpleConstraintContactMgr* m_contactMgr;
};

#include <Physics2012/Dynamics/Collide/ContactListener/hkpCollisionEvent.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
