// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Collide/ContactListener/Util/hkpCollisionCallbackUtil.h>

#include <Physics2012/Dynamics/Entity/Util/hkpEntityCallbackUtil.h>
#include <Physics2012/Dynamics/World/Util/hkpWorldCallbackUtil.h>

void hkpCollisionCallbackUtil::performAttachments( hkpWorld* world )
{
    world->addConstraintListener( this );
    world->addWorldPostSimulationListener( &m_endOfStepCallbackUtil );
}

void hkpCollisionCallbackUtil::performDetachments( hkpWorld* world )
{
    world->removeWorldPostSimulationListener( &m_endOfStepCallbackUtil );
    world->removeConstraintListener( this );
}

void hkpCollisionCallbackUtil::constraintAddedCallback( hkpConstraintInstance* constraint )
{
    HK_TIMER_BEGIN("CollLtUtil", HK_NULL);
    const hkpConstraintData *const data = constraint->getData();
    if ( data->getType() == hkpConstraintData::CONSTRAINT_TYPE_CONTACT )
    {
        const hkpSimpleContactConstraintData *const contactData = static_cast<const hkpSimpleContactConstraintData*>( data );
        hkpSimpleConstraintContactMgr *const mgr = contactData->getSimpleConstraintContactMgr();
        hkpRigidBody *const bodyA = constraint->getRigidBodyA();
        hkpRigidBody *const bodyB = constraint->getRigidBodyB();
        hkpCollisionEvent event( hkpCollisionEvent::SOURCE_WORLD, bodyA, bodyB, mgr );
        hkpWorld *const world = bodyA->getWorld();
        hkpWorldCallbackUtil::fireContactConstraintAddedCallback( world, event );

        event.m_source = hkpCollisionEvent::SOURCE_A;
        hkpEntityCallbackUtil::fireContactConstraintAddedCallback( bodyA, event );

        event.m_source = hkpCollisionEvent::SOURCE_B;
        hkpEntityCallbackUtil::fireContactConstraintAddedCallback( bodyB, event );
    }
    HK_TIMER_END();
}

void hkpCollisionCallbackUtil::constraintRemovedCallback( hkpConstraintInstance* constraint )
{
    HK_TIMER_BEGIN("CollLfUtil", HK_NULL);
    const hkpConstraintData *const data = constraint->getData();
    if ( data->getType() == hkpConstraintData::CONSTRAINT_TYPE_CONTACT )
    {
        const hkpSimpleContactConstraintData *const contactData = static_cast<const hkpSimpleContactConstraintData*>( data );
        hkpSimpleConstraintContactMgr *const mgr = contactData->getSimpleConstraintContactMgr();
        hkpRigidBody *const bodyA = constraint->getRigidBodyA();
        hkpRigidBody *const bodyB = constraint->getRigidBodyB();
        hkpCollisionEvent event( hkpCollisionEvent::SOURCE_WORLD, bodyA, bodyB, mgr );
        hkpWorld *const world = bodyA->getWorld();
        hkpWorldCallbackUtil::fireContactConstraintRemovedCallback( world, event );

        event.m_source = hkpCollisionEvent::SOURCE_A;
        hkpEntityCallbackUtil::fireContactConstraintRemovedCallback( bodyA, event );

        event.m_source = hkpCollisionEvent::SOURCE_B;
        hkpEntityCallbackUtil::fireContactConstraintRemovedCallback( bodyB, event );
    }
    HK_TIMER_END();
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
