// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Action/hkpAction.h>
#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>



    /// You can use this as a base class for hkpActions that operate on a single hkpEntity.
    /// In addition to the hkpAction interface, this class provides
    /// some useful basic functionality for actions, such as a callback that
    /// removes the action from the simulation if its hkpEntity is removed.
class HK_EXPORT_PHYSICS_2012 hkpUnaryAction : public hkpAction
{
    public:
    HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

            /// Constructor creates a hkpUnaryAction that operates on the specified hkpEntity.
        hkpUnaryAction(hkpEntity* entity = HK_NULL, hkUlong userData = 0);

            /// Destructor.
        ~hkpUnaryAction()
        {
            if (m_entity != HK_NULL)
            {
                m_entity->removeReference();
                m_entity = HK_NULL;
            }
        }

            /// hkpAction interface implementation.
        virtual void getEntities( hkArray<hkpEntity*>& entitiesOut );

            /// Remove self from the hkpWorld when the hkpEntity is removed.
        virtual void entityRemovedCallback(hkpEntity* entity);

            /// Sets m_entity, adds a reference to it and adds the action as a listener.
            /// NB: Only intended to be called pre-simulation i.e., before hkpUnaryAction
            /// is added to an hkpWorld.
        void setEntity(hkpEntity* entity);

            /// Returns m_entity.
        inline hkpEntity* getEntity();

            /// Returns m_entity cast to hkpRigidBody.
        inline hkpRigidBody* getRigidBody();

            /// The applyAction() method does the actual work of the action, and is called at every simulation step.
        virtual void applyAction( const hkStepInfo& stepInfo ) = 0;

    protected:

            /// The hkpEntity.
        hkpEntity* m_entity;    //+hk.Link("PARENT_NAME")
};

#include <Physics2012/Dynamics/Action/hkpUnaryAction.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
