// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Dynamics/hkpDynamics.h>
#include <Physics2012/Dynamics/Action/hkpUnaryAction.h>
#include <Physics2012/Dynamics/Entity/hkpEntity.h>
#include <Physics2012/Dynamics/World/hkpWorld.h>

hkpUnaryAction::hkpUnaryAction(hkpEntity* entity, hkUlong userData )
: hkpAction( userData ), m_entity(entity)
{
    if (m_entity != HK_NULL)
    {
        m_entity->addReference();
    }
    else
    {
        //  HK_WARN(0x4621e7da, "hkpUnaryAction: body is a NULL pointer");
    }
}

void hkpUnaryAction::entityRemovedCallback(hkpEntity* entity)
{
    // Remove self from physics.
    if ( getWorld() != HK_NULL )
    {
        getWorld()->removeActionImmediately(this);
    }
}

// NB: Only intended to be called pre-simulation i.e. before the hkpUnaryAction is
// added to an hkpWorld.
void hkpUnaryAction::setEntity(hkpEntity* entity)
{
    //HK_ASSERT(0x76017ab2, getWorld() == HK_NULL, "This hkpUnaryAction is already added to an hkpWorld.");
    HK_ASSERT(0x5163bcc3, entity != HK_NULL, "entity is a NULL pointer. You can use hkpWorld::getFixedRigidBody().");
    if(m_entity != HK_NULL)
    {
        HK_WARN(0x17aaa816, "m_entity is not NULL. This hkpUnaryAction already had an hkpEntity.");

        if (getWorld())
        {
            getWorld()->detachActionFromEntity(this, m_entity);
        }
        m_entity->removeReference();
        m_entity = HK_NULL;
    }

    m_entity = entity;
    m_entity->addReference();
    if (getWorld())
    {
        getWorld()->attachActionToEntity(this, m_entity);
    }
}

void hkpUnaryAction::getEntities( hkArray<hkpEntity*>& entitiesOut )
{
    entitiesOut.pushBack( m_entity );
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
