// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Dynamics/Action/hkpAction.h>
class hkpRigidBody;


    /// You can use this as a base class for hkActions that operate on a pair of
    /// hkRigidBodies. In addition to the hkpAction interface, this class provides
    /// some useful basic functionality for actions, such as a callback that removes
    /// the action from the simulation if either of its hkRigidBodies is removed.
class HK_EXPORT_PHYSICS_2012 hkpBinaryAction : public hkpAction
{
    public:
        HK_DECLARE_CLASS(hkpBinaryAction, New, Reflect, BypassCtor);

            /// Constructor creates a new hkpBinaryAction that operates on the specified entities.
        hkpBinaryAction( hkpEntity* entityA, hkpEntity* entityB, hkUlong userData = 0 );

            /// hkpAction interface implementation.
        virtual void getEntities( hkArray<hkpEntity*>& entitiesOut );

            /// Removes the action from the hkpWorld if one of its hkRigidBodies is removed.
        virtual void entityRemovedCallback(hkpEntity* entity);

            /// Sets m_bodyA, adds a reference to it and adds the action as a listener.
            /// NB: Only intended to be called pre-simulation i.e., before hkpBinaryAction
            /// is added to an hkpWorld.
        void setEntityA( hkpEntity* entityA);

            /// Gets m_bodyA.
        inline hkpEntity* getEntityA();

            /// Sets m_bodyB, adds a reference to it and adds the action as a listener.
            /// NB: Only intended to be called pre-simulation i.e., before hkpBinaryAction
            /// is added to an hkpWorld.
        void setEntityB( hkpEntity* entityB);

            /// Gets m_bodyB.
        inline hkpEntity* getEntityB();

            /// The applyAction() method does the actual work of the action, and is called at every simulation step.
        virtual void applyAction( const hkStepInfo& stepInfo ) = 0;

            /// Destructor.
        virtual ~hkpBinaryAction()
        {
            if (m_entityA != HK_NULL)
            {
                m_entityA->removeReference();
                m_entityA = HK_NULL;
            }

            if (m_entityB != HK_NULL)
            {
                m_entityB->removeReference();
                m_entityB = HK_NULL;
            }
        }

    protected:

            /// The first entity.
        hkpEntity* m_entityA;//+hk.Ui(group="Attach to", visible=false) +hk.Link("PARENT_NAME")

            /// The second entity.
        hkpEntity* m_entityB;//+hk.Ui(visible=true, label="Other Body", endGroup=true) +hk.Link("MESH")

        void _referenceBodies();
};

#include <Physics2012/Dynamics/Action/hkpBinaryAction.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
