// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/Util/hkpSphereUtil.h>
#include <Geometry/Internal/Algorithms/RayCast/hkcdRayCastSphere.h>


HK_INLINE hkBool hkpRayCastSphere(hkVector4Parameter rayFrom, hkVector4Parameter rayTo, hkReal radius, hkpShapeRayCastOutput& results)
{
    // Adapt the parameters for calling hkcdRayCastSphere.
    hkcdRay ray; ray.setEndPoints(rayFrom, rayTo);
    hkVector4 spherePosRadius; spherePosRadius.setXYZ_W(hkVector4::getZero(), hkSimdReal::fromFloat(radius));
    hkSimdReal hitFraction; hitFraction.load<1>( (const hkReal*)&(results.m_hitFraction) );

    if( hkcdRayCastSphere(ray, spherePosRadius, &hitFraction, &results.m_normal, hkcdRayQueryFlags::NO_FLAGS).isHit() )
    {
        hitFraction.store<1>( (hkReal*)&(results.m_hitFraction) );
        results.setKey(HK_INVALID_SHAPE_KEY);
        return true;
    }

    return false;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
