// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkcdShape.h>


    /// Utility to patch hkcdShape virtual tables.
struct HK_EXPORT_PHYSICS_2012 hkcdShapeVirtualTableUtil
{
    public:

        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_GEOMETRY, hkcdShapeVirtualTableUtil );

    public:

            /// Replace the virtual table for the given shape. The shape type must be valid before this is called.
        static void HK_CALL patchVirtualTable( hkcdShape* shape );

    public:

            /// Virtual table patch addresses for each hkcdShapeType that supports patching
        static hkUlong s_virtualTablePatches[];

#if defined(HK_DEBUG)

        // Debug only, for self tests
        static hkUint32 s_unregisteredFunctions;

#endif
};

// Macro for patching a shape's vtable. Applied only on SPU.
#define HKCD_PATCH_SHAPE_VTABLE( shapePtr )

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
