// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Util/ShapeVirtualTable/hkcdShapeVirtualTableUtil.h>


hkUlong hkcdShapeVirtualTableUtil::s_virtualTablePatches[] =
{
    0,          // hkcdShapeType::SPHERE
    0,          // hkcdShapeType::CYLINDER
    0,          // hkcdShapeType::TRIANGLE
    0,          // hkcdShapeType::BOX
    0,          // hkcdShapeType::CAPSULE
    0,          // hkcdShapeType::CONVEX_VERTICES

    0,          // hkcdShapeType::TRI_SAMPLED_HEIGHT_FIELD_COLLECTION
    0,          // hkcdShapeType::TRI_SAMPLED_HEIGHT_FIELD_BV_TREE
    0,          // hkcdShapeType::LIST
    0,          // hkcdShapeType::MOPP

    0,          // hkcdShapeType::CONVEX_TRANSLATE
    0,          // hkcdShapeType::CONVEX_TRANSFORM
    0,          // hkcdShapeType::SAMPLED_HEIGHT_FIELD

    0,          // hkcdShapeType::EXTENDED_MESH
    0,          // hkcdShapeType::TRANSFORM
    0,          // hkcdShapeType::COMPRESSED_MESH
    0,          // hkcdShapeType::STATIC_COMPOUND
    0,          // hkcdShapeType::BV_COMPRESSED_MESH
    0,          // hkcdShapeType::COLLECTION

    0,          // hkcdShapeType::USER_0
    0,          // hkcdShapeType::USER_1
    0,          // hkcdShapeType::USER_2
};

HK_COMPILE_TIME_ASSERT( sizeof(hkcdShapeVirtualTableUtil::s_virtualTablePatches) == sizeof(hkUlong) * hkcdShapeType::MAX_SPU_SHAPE_TYPE );


#if defined(HK_DEBUG)
hkUint32 hkcdShapeVirtualTableUtil::s_unregisteredFunctions = 0;
#endif

void HK_CALL hkcdShapeVirtualTableUtil::patchVirtualTable( hkcdShape* shape )
{
    const hkcdShape::ShapeType shapeType = shape->getType();
    HK_ASSERT_NO_MSG( 0x63e07b56, shapeType >= hkcdShapeType::FIRST_SHAPE_TYPE && shapeType < hkcdShapeType::MAX_SPU_SHAPE_TYPE );

    const hkUlong patchAddress = s_virtualTablePatches[ shapeType ];
    reinterpret_cast<hkUlong*>(shape)[0] = patchAddress;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
