// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkpShape;

/// This class supports a routine for traversing shapes hierarchy to discover their depth.
class HK_EXPORT_PHYSICS_2012 hkpShapeDepthUtil
{
    public:
            /// Calculates the depth of the shape.
            /// \return s_defaultMinimumChildDepth (default is 0) for leaf shapes, e.g., sphere shapes.
            /// \return 1 + the maximum depth of its children for compound shapes or s_defaultMinimumChildDepth, depending on whichever value is larger.
        static hkUint8 HK_CALL getShapeDepth( const hkpShape* shape );

    public:

        /// The minimum child depth returned by getShapeDepth(). Default is 0.
        static hkUint8 s_defaultMinimumChildDepth;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
