// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Physics2012/Collide/Util/Deprecated/ConvexHull/hkGeomEdge.h>

enum neighbourDirection
{
    CLOCKWISE = -1,
    COUNTERCLOCKWISE = 1,
    NEIGHBOURDIRECTION_MAX
};


typedef hkUint16 hkGeomEdgeIndex;


/// This is an internal structure used by the convex hull algorithm.
class HK_EXPORT_PHYSICS_2012 hkGeomHull
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_GEOMETRY, hkGeomHull );

        hkGeomHull();

        void initializeWithVertex( int vertexIndex );
        void initializeWithEdge  ( int v1, int v2 );
        void initializeWithTriangle( int v1, int v2, int v3 );


        hkBool isValidTopology();
        void visitAllNextAndMirrorEdges( hkGeomEdge* edge );

        //void simplifyTopology();

    public:
        // done implicitely by iterating over the connectivity, void getNeighbours( const hkVector4* vertex, hkArray<neighbourVertex>& neighbours );
        struct WrappingEdge
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_GEOMETRY, hkGeomHull::WrappingEdge );

            hkGeomEdgeIndex m_index[2];
        };

        // The convex hull is represented as a collection of vertices and edges; the
        // edges form a doubly-connected-edge-list.

        hkVector4* m_vertexBase;

        hkInplaceArray<hkGeomEdge,128> m_edges;
};

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
