// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Util/Deprecated/ConvexHull/hkGeomHull.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

hkGeomHull::hkGeomHull( )
: m_vertexBase( HK_NULL )
{
    m_edges.setSize(0);
}


void hkGeomHull::initializeWithVertex( int vertexIndex )
{
    m_edges.clear();

    hkGeomEdge singleVertexEdge;

    singleVertexEdge.m_vertex = hkUint16(vertexIndex);
    singleVertexEdge.m_mirror = 0;
    singleVertexEdge.m_next = 0;

    m_edges.pushBack( singleVertexEdge );

    //HK_DISPLAY_STAR( *singleVertexEdge.getVertex( m_vertexBase ), 0.5f, hkColor::RED );
}


void hkGeomHull::initializeWithEdge( int v1, int v2 )
{
    m_edges.clear();

    hkGeomEdge singleEdge;
    hkGeomEdge singleEdgeMirror;

    singleEdge.m_vertex = hkUint16(v1);
    singleEdge.m_mirror = 1;
    singleEdge.m_next = 1;

    singleEdgeMirror.m_vertex = hkUint16(v2);
    singleEdgeMirror.m_mirror = 0;
    singleEdgeMirror.m_next = 0;

    m_edges.pushBack( singleEdge );
    m_edges.pushBack( singleEdgeMirror );

    //HK_DISPLAY_LINE( m_vertexBase[v1], m_vertexBase[v2], hkColor::BLUE );
}

void hkGeomHull::initializeWithTriangle( int v1, int v2, int v3 )
{
    m_edges.clear();

    //
    // Check if the points are collinear.
    //

    hkSimdReal lenT1, lenT2, lenT3;
    hkVector4 t1; t1.setSub( m_vertexBase[v2], m_vertexBase[v1] ); lenT1 = t1.lengthSquared<4>();
    hkVector4 t2; t2.setSub( m_vertexBase[v3], m_vertexBase[v2] ); lenT2 = t2.lengthSquared<4>();
    hkVector4 t3; t3.setSub( m_vertexBase[v1], m_vertexBase[v3] ); lenT3 = t3.lengthSquared<4>();

    t1.normalize<3>(); t2.normalize<3>(); t3.normalize<3>();


    hkVector4 difference;
    difference.setSub( t2, t1 );
    if ( difference.lengthSquared<3>() < hkSimdReal::fromFloat(0.000001f) )
    {
        // The points are collinear, so
        // determine which points are the endpoints.

        hkSimdReal maxT2T3; maxT2T3.setMax(lenT2,lenT3);
        hkSimdReal maxLen; maxLen.setMax( lenT1, maxT2T3 );

        if ( lenT1.isEqual(maxLen) )
        {
            initializeWithEdge( v1, v2 );
        }
        else if ( lenT2.isEqual(maxLen) )
        {
            initializeWithEdge( v2, v3 );
        }
        else if ( lenT3.isEqual(maxLen) )
        {
            initializeWithEdge( v3, v1 );
        }
        return;
    }


    // Add the three verts and link them into a triangle.

    hkGeomEdge e0_v1v2;
    hkGeomEdge e1_v2v1;
    hkGeomEdge e2_v2v3;
    hkGeomEdge e3_v3v2;
    hkGeomEdge e4_v3v1;
    hkGeomEdge e5_v1v3;


    e0_v1v2.m_vertex = hkUint16(v1);
    e0_v1v2.m_mirror = 1;
    e0_v1v2.m_next = 2;

    e1_v2v1.m_vertex = hkUint16(v2);
    e1_v2v1.m_mirror = 0;
    e1_v2v1.m_next = 5;

    e2_v2v3.m_vertex = hkUint16(v2);
    e2_v2v3.m_mirror = 3;
    e2_v2v3.m_next = 4;

    e3_v3v2.m_vertex = hkUint16(v3);
    e3_v3v2.m_mirror = 2;
    e3_v3v2.m_next = 1;

    e4_v3v1.m_vertex = hkUint16(v3);
    e4_v3v1.m_mirror = 5;
    e4_v3v1.m_next = 0;

    e5_v1v3.m_vertex = hkUint16(v1);
    e5_v1v3.m_mirror = 4;
    e5_v1v3.m_next = 3;

    m_edges.pushBack( e0_v1v2 );
    m_edges.pushBack( e1_v2v1 );
    m_edges.pushBack( e2_v2v3 );
    m_edges.pushBack( e3_v3v2 );
    m_edges.pushBack( e4_v3v1 );
    m_edges.pushBack( e5_v1v3 );

//  HK_DISPLAY_LINE( m_vertexBase[v1], m_vertexBase[v2], hkColor::BLUE );
//  HK_DISPLAY_LINE( m_vertexBase[v2], m_vertexBase[v3], hkColor::BLUE );
//  HK_DISPLAY_LINE( m_vertexBase[v3], m_vertexBase[v1], hkColor::BLUE );
}

void hkGeomHull::visitAllNextAndMirrorEdges( hkGeomEdge* startEdge )
{
    hkGeomEdge* edgeBase = m_edges.begin();

    hkInplaceArray<hkGeomEdge*,1024> openEdges;
    openEdges.pushBackUnchecked( startEdge );

    while ( openEdges.getSize())
    {
        hkGeomEdge* edge = openEdges.back();
        openEdges.popBack();

        //
        //  Run through all 3 edges
        //
        {
            hkGeomEdge* nextEdge = edge;
            do
            {
                nextEdge = nextEdge->getNext( edgeBase );
                nextEdge->m_info = 1;
            }
            while ( nextEdge != edge);
        }

        //
        //  Recurse the 3 mirros
        //
        {
            hkGeomEdge* nextEdge = edge;
            do
            {
                nextEdge = nextEdge->getNext( edgeBase );
                hkGeomEdge* mirrorEdge = nextEdge->getMirror( edgeBase );
                if ( mirrorEdge->m_info == 0 )
                {
                    openEdges.pushBack( mirrorEdge );
                }
            }
            while ( nextEdge != edge);
        }
    }
}


hkBool hkGeomHull::isValidTopology()
{
    // The topology is considered valid if:
    //
    // 1. every edge has a mirror and the mirror mirror is the edge
    //
    // 2. the vertex for the next of the mirror of an edge is
    //    the same as the vertex of that edge, i.e. that an edge
    //    points away from it's vertex.
    //
    // 3. the next of the next of the next of an edge is that edge, i.e.
    //    the hull consists only of triangles.
    //
    // 4. a flood-fill from edges and mirrors of edges covers
    //    the entire hull, i.e. the hull is connected.
    //
    // 5. there is only one pair of edges that are the mirror of each other and
    //    contain the same vertices.

    hkGeomEdge* edgeBase = m_edges.begin();

    hkBool topologyIsValid = true;

    // 1. every edge has a mirror,
    {
        for ( int ie = 0 ; ie < m_edges.getSize() ; ie++ )
        {
            // simply check if the mirror is a member of m_edges
            hkBool isValidMirror;
            int mirror = m_edges[ie].m_mirror;
            isValidMirror = (( 0 <= mirror ) && ( mirror < m_edges.getSize() ));

            topologyIsValid = topologyIsValid && isValidMirror;
            HK_ASSERT_NO_MSG(0x618d6ff9, topologyIsValid );

            topologyIsValid = topologyIsValid && (m_edges[mirror].m_mirror == ie);
            HK_ASSERT_NO_MSG(0x7b1c7b9d, topologyIsValid );
        }
    }

    // 2. orientation of edges check
    {
        for ( int ie = 0 ; ie < m_edges.getSize() ; ie++ )
        {
            hkUint16 vertToCheck = m_edges[ie].getMirror( edgeBase )->getNext( edgeBase )->m_vertex;

            topologyIsValid = topologyIsValid && (vertToCheck == m_edges[ie].m_vertex);
            HK_ASSERT_NO_MSG(0x2e020db2, topologyIsValid );
        }
    }

    // 3. triangle check
    {
        if ( m_edges.getSize() > 2 )
        {
            for ( int ie = 0 ; ie < m_edges.getSize() ; ie++ )
            {
                int edgeToCheck = m_edges[ie].getNext( edgeBase )->getNext( edgeBase )->m_next;

                topologyIsValid = topologyIsValid && (ie == edgeToCheck);
                HK_ASSERT_NO_MSG(0x437b40b6, topologyIsValid );
            }
        }
    }

    // 4. flood-fill check
    {
        // clear the visited flag
        for ( int jn = 0 ; jn < m_edges.getSize() ; jn++ )
        {
            m_edges[jn].m_info = 0;
        }

        visitAllNextAndMirrorEdges( m_edges.begin() );

        // check if there are any unvisited edges
        for ( int je = 0 ; je < m_edges.getSize() ; je++ )
        {
            topologyIsValid = topologyIsValid && (m_edges[je].m_info == 1);
            HK_ASSERT_NO_MSG(0x248938e3, topologyIsValid );
        }
    }


    // 5. for every vertex, we get the same neighbours regardless
    //    of which edge we start from.
    if(0)
    {
        // clear the visited flag
        for ( int jn = 0 ; jn < m_edges.getSize() ; jn++ )
        {
            m_edges[jn].m_info = 0;
        }

        // how many vertices are there?
        int vertexCount = 0;
        {
            for ( int i = 0 ; i < m_edges.getSize() ; i++ )
            {
                vertexCount = ( m_edges[i].m_vertex > vertexCount ) ? m_edges[i].m_vertex : vertexCount;
            }
        }


        hkInplaceArray<int, 64> previousNeighbourSet;
        hkInplaceArray<int, 64> neighbourSet;

        for ( int iv = 0 ; iv < vertexCount ; iv++ )
        {
            previousNeighbourSet.clear();
            neighbourSet.clear();
            for ( int ie = 0 ; ie < m_edges.getSize() ; ie++ )
            {
                if ( m_edges[ie].m_vertex == iv )
                {
                    // if we haven't visited this edge yet:
                    if ( m_edges[ie].m_info != 1 )
                    {
                        hkGeomEdge* startNeighbour = m_edges[ie].getMirror( edgeBase );
                        hkGeomEdge* currentNeighbour = startNeighbour;
                        do {
                            neighbourSet.pushBack( currentNeighbour->m_vertex );

                            currentNeighbour->getNext( edgeBase )->m_info = 1;
                            currentNeighbour = currentNeighbour->getNext( edgeBase )->getMirror( edgeBase );
                        } while( currentNeighbour != startNeighbour );

                        hkSort( neighbourSet.begin(), neighbourSet.getSize());

                        if ( previousNeighbourSet.getSize() != 0 )
                        {
                            topologyIsValid = topologyIsValid && (neighbourSet.getSize() == previousNeighbourSet.getSize());
                            HK_ASSERT_NO_MSG( 0x7e9c1e54, topologyIsValid );
                            for ( int in = 0 ; in < neighbourSet.getSize() ; in++ )
                            {
                                topologyIsValid = topologyIsValid && (previousNeighbourSet[in] == neighbourSet[in]);
                                HK_ASSERT_NO_MSG( 0x3af21fc6, topologyIsValid );
                            }
                        }

                        // copy the neighbourSet to previousNeighbourSet
                        {
                            previousNeighbourSet.clear();
                            previousNeighbourSet.setSize( neighbourSet.getSize() );
                            for ( int in = 0 ; in < neighbourSet.getSize() ; in++ )
                            {
                                previousNeighbourSet[in] = neighbourSet[in];
                            }
                        }
                    }
                }
            }
        }
    }

    return topologyIsValid;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
