// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Physics2012/Collide/Util/Deprecated/ConvexHull/hkGeomConvexHullTester.h>

//#define HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE

//#ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
//#undef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
//#endif


hkBool hkGeomConvexHullTester::isValidHull( const hkGeomConvexHullTolerances& tolerances,
                                   const hkVector4* initialVertsPointer, int numInitialVertices,
                                   hkGeomHull& hull, hkArray<hkVector4>& usedVerts )
{

    hkBool isPlanar = false;
    hkArray<hkGeomConvexHullBuilder::PlaneAndPoints> tangentPlanes;
    hkArray<hkVector4> planeEquations;

    hkReal coplanar_tolerance = tolerances.m_coplanar_tolerance;
//  {
//      hkReal maxVerticesExtent = hkGeomConvexHullBuilder::getMaxVertexExtent( usedVertices );
//      if ( maxVerticesExtent > 0.1f )
//      {
//          coplanar_tolerance *= 20*( maxVerticesExtent );
//      }
//  }


    hkArray<hkVector4> initialVerts;
    for ( int i = 0 ; i < numInitialVertices ; i++ )
    {
        initialVerts.pushBack( initialVertsPointer[i] );
    }

    hkVector4 extentsU, aabbCenterU;
    hkVector4 extentsI, aabbCenterI;
    if ( tolerances.m_runConvertToUnitCube )
    {
        hkGeomConvexHullBuilder::convertToUnitCube( usedVerts, extentsU, aabbCenterU );
        hkGeomConvexHullBuilder::convertToUnitCube( initialVerts, extentsI, aabbCenterI );
    }

    hkBool retVal = true;

    hkVector4 planarPlaneEquation;
    hkGeomConvexHullBuilder::buildPlaneEquations( tolerances, hull, usedVerts, planarPlaneEquation, isPlanar, planeEquations, tangentPlanes );

    if ( isPlanar )
    {
        retVal = isValidPlanarHull( initialVerts, hull, usedVerts, planeEquations, tangentPlanes, coplanar_tolerance );
    }
    else
    {
        retVal = isValidNonPlanarHull( initialVerts, hull, usedVerts, planeEquations, tangentPlanes, coplanar_tolerance );
    }

    if ( tolerances.m_runConvertToUnitCube )
    {
        hkGeomConvexHullBuilder::convertFromUnitCube( usedVerts, extentsU, aabbCenterU );
        hkGeomConvexHullBuilder::convertFromUnitCube( initialVerts, extentsI, aabbCenterI );
    }

    return retVal;
}


hkBool hkGeomConvexHullTester::checkPlaneEquations( hkArray<hkVector4>& initialVerts, hkArray<hkVector4>& usedVertices, hkArray<hkVector4>& planeEquations, hkReal coplanar_tolerance )
{
    hkBool planeEquationsAreValid = true;

    for ( int ip = 0 ; planeEquationsAreValid && (ip < planeEquations.getSize()); ip++ )
    {
        //
        //  No points in the initial point cloud lie outside any triangle (to within a tolerance defined by)
        //

        for ( int iv = 0 ; planeEquationsAreValid && (iv < initialVerts.getSize()) ; iv++ )
        {
            hkReal distToPlane = planeEquations[ip].dot4xyz1( initialVerts[iv] ).getReal();
            planeEquationsAreValid = planeEquationsAreValid && ( distToPlane < coplanar_tolerance );

#           ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
            HK_ASSERT_NO_MSG( 0x237e1b95, planeEquationsAreValid );
#           endif
        }

        //
        //  No point in the output set of points lies inside any triangles(to within a tolerance)
        //

        for ( int iu = 0 ; planeEquationsAreValid && (iu < usedVertices.getSize()); iu++ )
        {
            planeEquationsAreValid = planeEquationsAreValid && ( planeEquations[ip].dot4xyz1( usedVertices[iu] ).getReal() < coplanar_tolerance );
#           ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
            HK_ASSERT_NO_MSG( 0x247e1b95, planeEquationsAreValid );
#           endif
        }
    }

    return planeEquationsAreValid;
}



hkBool hkGeomConvexHullTester::findSameEdges( const hkGeomConvexHullBuilder::PlaneAndPoints& pp1, const hkGeomConvexHullBuilder::PlaneAndPoints& pp2, hkBool& found01, hkBool& found02, hkBool& found12 )
{
    int t1p0 = pp1.m_v0->m_vertex;
    int t1p1 = pp1.m_v1->m_vertex;
    int t1p2 = pp1.m_v2->m_vertex;
    int t2p0 = pp2.m_v0->m_vertex;
    int t2p1 = pp2.m_v1->m_vertex;
    int t2p2 = pp2.m_v2->m_vertex;
    // there are only 7 possible combinations


    hkBool notAlreadyFound = true;

    if ( t1p0 == t2p0 )
    {
        if (( t1p1 == t2p1 ) || ( t1p1 == t2p2 ))
        {
            if ( found01 ) { notAlreadyFound = false; }
            found01 = true;
        }

        if (( t1p2 == t2p1 ) || ( t1p2 == t2p2 ))
        {
            if ( found02 ) { notAlreadyFound = false; }
            found02 = true;
        }
    }


    if ( t1p0 == t2p1 )
    {
        if ( t1p1 == t2p2 )
        {
            if ( found01 ) { notAlreadyFound = false; }
            found01 = true;
        }

        if ( t1p2 == t2p2 )
        {
            if ( found02 ) { notAlreadyFound = false; }
            found02 = true;
        }
    }


    if ( (( t1p1 == t2p0 ) && ( t1p2 == t2p1 )) ||
         (( t1p1 == t2p0 ) && ( t1p2 == t2p2 )) ||
         (( t1p1 == t2p1 ) && ( t1p2 == t2p2 )) )
    {
        if ( found12 ) { notAlreadyFound = false; }
        found12 = true;
    }

    return notAlreadyFound;
}

hkBool hkGeomConvexHullTester::isValidPlanarHull( hkArray<hkVector4>& initialVerts, hkGeomHull& hull, hkArray<hkVector4>& usedVertices, hkArray<hkVector4>& planeEquations, hkArray<hkGeomConvexHullBuilder::PlaneAndPoints>& tangentPlanes, hkReal coplanar_tolerance )
{
    hkBool planarHullIsValid = true;

    //
    //  No points in the initial point cloud lie outside any triangle (to within a tolerance)
    //

    planarHullIsValid = planarHullIsValid && checkPlaneEquations( initialVerts, usedVertices, planeEquations, coplanar_tolerance );

#   ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
    HK_ASSERT_NO_MSG( 0x257e1b95, planarHullIsValid );
#   endif


    //
    //  Each edge has at least two triangles.
    //


    for ( int it = 0 ; it < tangentPlanes.getSize() ; it++ )
    {
        hkBool found01 = false, found02 = false, found12 = false;

        for ( int jt = 0; jt < tangentPlanes.getSize() ; jt++)
        {
            if ( jt != it )
            {
                findSameEdges( tangentPlanes[it], tangentPlanes[jt], found01, found02, found12 );
            }
        }

        planarHullIsValid = planarHullIsValid && found01 && found02 && found12;

#       ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
        HK_ASSERT_NO_MSG( 0x267e1b95, planarHullIsValid );
#       endif

    }

    return planarHullIsValid;
}


hkBool hkGeomConvexHullTester::isValidNonPlanarHull( hkArray<hkVector4>& initialVerts, hkGeomHull& hull, hkArray<hkVector4>& usedVertices, hkArray<hkVector4>& planeEquations, hkArray<hkGeomConvexHullBuilder::PlaneAndPoints>& tangentPlanes, hkReal coplanar_tolerance )
{
    hkBool nonPlanarHullIsValid = true;

    nonPlanarHullIsValid = nonPlanarHullIsValid && checkPlaneEquations( initialVerts, usedVertices, planeEquations, coplanar_tolerance );

#   ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
    HK_ASSERT_NO_MSG( 0x277e1b95, nonPlanarHullIsValid );
#   endif

    {

        for ( int it = 0 ; it < tangentPlanes.getSize() ; it++ )
        {
            //
            //  No triangle has the same point twice
            //

            nonPlanarHullIsValid = nonPlanarHullIsValid && ! (( tangentPlanes[it].m_v0->m_vertex == tangentPlanes[it].m_v1->m_vertex ) ||
                                       ( tangentPlanes[it].m_v1->m_vertex == tangentPlanes[it].m_v2->m_vertex ));


#           ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
            HK_ASSERT_NO_MSG( 0x287e1b95, nonPlanarHullIsValid );
#           endif

            {
                hkBool found01 = false, found02 = false, found12 = false;

                for ( int jt = 0; jt < tangentPlanes.getSize() ; jt++)
                {
                    //
                    //  No triangle exists more than once
                    //

                    if ( jt != it )
                    {
                        hkSimdReal eps; eps.setFromFloat(1e-3f);
                        nonPlanarHullIsValid = nonPlanarHullIsValid &&
                                                 !(( tangentPlanes[it].m_v0->m_vertex == tangentPlanes[jt].m_v0->m_vertex ) &&
                                                  ( tangentPlanes[it].m_v1->m_vertex == tangentPlanes[jt].m_v1->m_vertex ) &&
                                                  ( tangentPlanes[it].m_v2->m_vertex == tangentPlanes[jt].m_v2->m_vertex ) &&
                                                  ( tangentPlanes[it].m_planeEquation.allEqual<4>(tangentPlanes[jt].m_planeEquation,eps) ) );





#                       ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
                        HK_ASSERT_NO_MSG( 0x297e1b95, nonPlanarHullIsValid );
#                       endif


                        //
                        //  Each edge has exactly two triangles
                        //

                        nonPlanarHullIsValid = nonPlanarHullIsValid && findSameEdges( tangentPlanes[it], tangentPlanes[jt], found01, found02, found12 );

#                       ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
                        HK_ASSERT_NO_MSG( 0x267e1ca5, nonPlanarHullIsValid );
#                       endif
                    }
                }

                nonPlanarHullIsValid = nonPlanarHullIsValid && found01 && found02 && found12;

#               ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
                HK_ASSERT_NO_MSG( 0x267e1c95, nonPlanarHullIsValid );
#               endif
            }
        }
    }


    //
    //  All windings are the same with respect to the centroid of the hull
    //
    {

    }

    //
    //  Check Euler's formla: Edges +2 = num faces  + num vertices
    //
    //  num faces = num triangles
    //
    {
        int numEdges = hull.m_edges.getSize() / 2;
        int numFaces = tangentPlanes.getSize();
        int numVertices = usedVertices.getSize();

        if ( numVertices > 2 )
        {
            nonPlanarHullIsValid = nonPlanarHullIsValid && ( numVertices + numFaces - numEdges - 2 == 0 );

#           ifdef HK_DEBUG_CONVEX_HULL_ASSERT_ON_FAILURE
            HK_ASSERT_NO_MSG( 0x227e6b95, nonPlanarHullIsValid );
#           endif
        }
    }

    return nonPlanarHullIsValid;
}

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
