// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>
#include <Physics2012/Collide/Shape/Convex/Cylinder/hkpCylinderShape.h>

#define DEBUG_LOG_IDENTIFIER "test.p12.shape.cylinder"
#include <Common/Base/System/Log/hkLog.hxx>


static void testGetAabb()
{
    const int numTests = 1000;
    const hkReal halfLength = 10;
    const int numSegments = 128;

    hkPseudoRandomGenerator rnd(1);
    hkpCylinderShape::setNumberOfVirtualSideSegments(numSegments);
    hkVector4 min; min.set(-halfLength, -halfLength, -halfLength);
    hkVector4 max; max.set(halfLength, halfLength, halfLength);
    hkVector4 totalDifferenceMin; totalDifferenceMin.setZero();
    hkVector4 totalDifferenceMax; totalDifferenceMax.setZero();
    hkVector4 totalHalfExtents; totalHalfExtents.setZero();

    for (int i = 0; i < numTests; ++i)
    {
        // Create cylinder with random vertices and radius
        hkVector4 vertexA;
        hkVector4 vertexB;
        rnd.getRandomVectorRange(min, max, vertexA);
        rnd.getRandomVectorRange(min, max, vertexB);
        hkReal radius = halfLength * rnd.getRandReal01();
        hkpCylinderShape cylinder(vertexA, vertexB, radius);

        // Obtain aabb
        hkAabb aabb;
        cylinder.getAabb(hkTransform::getIdentity(), 0, aabb);
        hkVector4 halfExtents;
        aabb.getHalfExtents(halfExtents);
        totalHalfExtents.add(halfExtents);

        // Test if the aabb contains the supporting vertices in all axis directions
        hkAabb aabbFromSupport; aabbFromSupport.setEmpty();
        for (int j = 0; j < 3; ++j)
        {
            hkcdVertex supportingVertex;
            hkVector4 direction; direction.setZero();
            direction(j) = 1;
            cylinder.getSupportingVertex(direction, supportingVertex);
            HK_TEST(aabb.containsPoint(supportingVertex));
            aabbFromSupport.includePoint(supportingVertex);
            direction.setNeg<3>(direction);
            cylinder.getSupportingVertex(direction, supportingVertex);
            HK_TEST(aabb.containsPoint(supportingVertex));
            aabbFromSupport.includePoint(supportingVertex);
        }

        // Keep track of the difference
        hkVector4 difference; difference.setSub(aabb.m_min, aabbFromSupport.m_min);
        difference.setAbs(difference);
        totalDifferenceMin.add(difference);
        difference.setSub(aabb.m_max, aabbFromSupport.m_max);
        difference.setAbs(difference);
        totalDifferenceMax.add(difference);
    }

    hkVector4 numTestsVec; numTestsVec.setAll(hkReal(numTests));
    totalDifferenceMin.div( numTestsVec );
    totalDifferenceMax.div( numTestsVec );
    totalHalfExtents.div( numTestsVec );
    Log_Info(
        "Average(aabb.m_max - supportingVertex) : {:,3}\n"
        "Average(aabb.m_min - supportingVertex) : {:,3}\n"
        "Average aabb volume : {}",
        totalDifferenceMax,
        totalDifferenceMin,
        8 * totalHalfExtents( 0 ) * totalHalfExtents( 1 ) * totalHalfExtents( 2 )
    );

}

int CylinderShapeUnitTest()
{
    testGetAabb();

    return 0;
}


HK_TEST_REGISTER( CylinderShapeUnitTest, "Fast", "Physics2012/Test/UnitTest/Collide/", __FILE__ );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
