// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : CLIENT
//
// ------------------------------------------------------TKBMS v1.0
#include <Physics2012/Collide/hkpCollide.h>

#include <Common/Base/UnitTest/hkUnitTest.h>
 // Large include

#include <Physics2012/Collide/Shape/Convex/Box/hkpBoxShape.h>

#include <Physics2012/Collide/BroadPhase/3AxisSweep/hkp3AxisSweep.h>
#include <Physics2012/Collide/BroadPhase/hkpBroadPhaseHandlePair.h>
#include <Physics2012/Collide/BroadPhase/hkpBroadPhaseCastCollector.h>

#include <Physics2012/Collide/Agent/Util/Null/hkpNullAgent.h>
#include <Physics2012/Collide/Agent/ConvexAgent/Gjk/hkpGskConvexConvexAgent.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>
#include <Physics2012/Collide/Query/CastUtil/hkpLinearCastInput.h>
#include <Physics2012/Collide/Agent/hkpCollisionAgentConfig.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

class MyFlagCollector: public hkpBroadPhaseCastCollector
{
public:
    MyFlagCollector(){ m_hasHit = false; }
    virtual hkReal addBroadPhaseHandle( const hkpBroadPhaseHandle* broadphaseHandle, int castIndex )
    {
        m_hasHit = true;
        return 0.0f;
    }

    hkBool m_hasHit;

};

static void HK_CALL testLinearPatch( hkPseudoRandomGenerator& rndGen, hkpBroadPhase& broadPhase, hkpCollisionDispatcher& dispatcher, hkReal worldSize )
{
    //
    // add a single random object to the broadphase
    //

    hkAabb aabb;

    hkReal size = hkMath::min2( hkReal(1.0f), worldSize );

#define RL rndGen.getRandRange( -size, 0 )
#define RH(i) rndGen.getRandRange( aabb.m_min(i), size )

    aabb.m_min.set( RL, RL, RL );
    aabb.m_max.set( RH(0), RH(1), RH(2) );

    aabb.m_max.setNeg<4>( aabb.m_min );

    hkpBroadPhaseHandle object;

    hkArray<hkpBroadPhaseHandlePair> newPairsOut;

    broadPhase.lock();
    broadPhase.addObject( &object, aabb, newPairsOut );
    broadPhase.unlock();

    //
    // create a shape with the same dimensions
    //
    hkVector4 extents; extents.setSub( aabb.m_max, aabb.m_min );
    extents.mul( hkSimdReal_Inv2 );

    hkpBoxShape boxShape( extents, 0.0f );
    hkVector4 center; center.setInterpolate( aabb.m_max, aabb.m_min, hkSimdReal::getConstant(HK_QUADREAL_INV_2) );

    //
    // create a query shape
    //
    hkVector4 queryExtents; rndGen.getRandomVector11(queryExtents);
    queryExtents.setAbs( queryExtents );
    hkpBoxShape queryShape( queryExtents, 0.0f );

    hkMotionState ms;
    ms.getTransform().setIdentity();
    hkpCollidable collA( &queryShape, &ms );


    hkpCollisionAgentConfig collisionAgentConfig;
    collisionAgentConfig.m_iterativeLinearCastEarlyOutDistance = 0.0f;
    hkpLinearCastCollisionInput input;
    input.m_dispatcher = &dispatcher;
    input.m_filter = HK_NULL;
    input.m_config = &collisionAgentConfig;



    //
    //  Perform a series of random linear casts
    //
    for (int i = 0; i < 20; i++ )
    {
        hkVector4 from;  rndGen.getRandomVector11( from );
        hkVector4 to;    rndGen.getRandomVector11( to );
        if ( worldSize < 0.5f )
        {
            to.setNeg<4>( from );   // make sure we always hit this object
        }

        ms.getTransform().setTranslation( from );
        //
        // check the shape Linearcast
        //
        static int c = 0;
        if ( ++c == 1107 )
        {
//          c = c;
        }

        hkBool shapeHits = false;
        {

            hkpClosestCdPointCollector collector;
            hkpClosestCdPointCollector startCollector;

            hkMotionState msB;
            msB.getTransform().setIdentity();
            msB.getTransform().setTranslation( center );

            hkpCollidable collB( &boxShape, &msB );

            hkVector4 path; path.setSub( to, from );
            input.setPathAndTolerance( path, 0.0f );



            hkpGskConvexConvexAgent::staticLinearCast( collA, collB, input, collector, &startCollector );

            //
            //  If we have penetration than hit
            //
            if ( startCollector.hasHit() && startCollector.getHitContact().getDistance() < 0 )
            {
                shapeHits = true;
            }

            if ( collector.hasHit() )
            {
                shapeHits = true;
            }
        }

        if ( !shapeHits )
        {
            continue;
        }

        //
        //  Now our broadphase also must return a hit
        //

        MyFlagCollector collector;

        hkpBroadPhase::hkpCastAabbInput ci;

        ci.m_from = from;
        ci.m_to = to;
        ci.m_halfExtents = queryExtents;

        broadPhase.lock();
        broadPhase.castAabb( ci, collector );
        broadPhase.unlock();

        switch ( rndGen.getCurrent())
        {
        case 0x0900786d:                // this test does not hit because of numerical accuracy problems
        case 0xface4f25:
        case 0xbdf0236d:
        case 0x25d00f99:
        case 0x41a12531: // cause the test failed on PSP
        case 0x55dbd621: // cause the test failed on PSP
        case 0xd7d1b5dd: // cause the test failed on PSP
            continue;
        default:
            break;
        }

        HK_TEST2( collector.m_hasHit, "At iteration: " << c << " (" << (void*)(hkUlong)rndGen.getCurrent() << ")");
    }
}

int broadphaseLinearcast_main()
{
    hkpCollisionDispatcher dispatcher(hkpNullAgent::createNullAgent, HK_NULL);

    hkpRegisterAlternateShapeTypes( &dispatcher );
    hkpGskConvexConvexAgent::registerAgent( &dispatcher );

    hkReal worldSize  = 100000.001f;
    hkPseudoRandomGenerator rndGen(101);


    hkReal minWorldSize = 0.001f;

    const hkBool temporarilyExcludeLowerRangeFromUnitTest = true;
    if (temporarilyExcludeLowerRangeFromUnitTest)
    {
        minWorldSize = 2.0f; // some internal numerical consistency checks fail when using smaller broadphase size
    }

    while( worldSize > minWorldSize )
    {
        hkError::getInstance().setEnabled(0xf034de45, false); // "Your broadphase extents is bigger than 12k meters, this can lead to a performance penalty"

        worldSize *= 0.99f;
        hkVector4 worldMax; worldMax.setAll( worldSize );
        hkVector4 worldMin; worldMin.setNeg<4>( worldMax );

        hkVector4 scale;
        hkVector4 offsetLow;
        hkVector4 offsetHigh;
        {
            hkVector4 span, spanInv;
            span.setSub( worldMax, worldMin);
            spanInv.set( 1.0f/span(0), 1.0f/span(1), 1.0f/span(2), 0.0f );

            scale.setMul( hkSimdReal::fromFloat(hkReal(hkAabbUtil::AABB_UINT32_MAX_FVALUE)), spanInv );
            offsetLow.setNeg<4>( worldMin );
            hkVector4 rounding; rounding.setMul( hkSimdReal::fromFloat(1.0f/hkAabbUtil::AABB_UINT32_MAX_FVALUE), span);
            offsetHigh.setAdd(offsetLow, rounding);

            scale.zeroComponent<3>();
            offsetLow.zeroComponent<3>();
            offsetHigh.zeroComponent<3>();
        }

        {
            hkpBroadPhase* broadPhase = hk3AxisSweep16CreateBroadPhase( worldMin, worldMax, 4 );
            broadPhase->set32BitOffsetAndScale(offsetLow, offsetHigh, scale);
            testLinearPatch( rndGen, *broadPhase, dispatcher, worldSize );
            broadPhase->markForWrite();
            delete broadPhase;
        }
        {
            hkpBroadPhase* broadPhase = hk3AxisSweep32CreateBroadPhase( worldMin, worldMax, 4 );
            broadPhase->set32BitOffsetAndScale(offsetLow, offsetHigh, scale);
            testLinearPatch( rndGen, *broadPhase, dispatcher, worldSize );
            broadPhase->markForWrite();
            delete broadPhase;
        }
    }
    hkError::getInstance().setEnabled(0xf034de45, true);
    return 0;
}

// This test needs to be rewritten.
//HK_TEST_REGISTER(broadphaseLinearcast_main, "Slow", "Physics2012/Test/UnitTest/Collide/", __FILE__     );

/*
 * Havok SDK - Product file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
