// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#include <Physics2012/Collide/hkpCollide.h>

#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Physics2012/Collide/Util/hkpTriangleUtil.h>
#include <Physics2012/Collide/Util/hkpCollideTriangleUtil.h>

// Make sure that if a triangle passes isDegenerate, it will not fail in closestPointTriangle

static int degenerate_triangles()
{
    // Three cases

    // Needles:
    // A-----------------------B
    // C
    // Caps:
    //       _____C______
    // A-----------------------B
    // Inbetweenies: (mixture of above)

    hkVector4 startPos[3];
    {
        startPos[0].set( 0,0,0 ); // L
        startPos[1].set( 1,0,0 ); // _|
        startPos[2].set( .5f,0,0 ); // ^
    }

    for( int testType = 0; testType < 3; ++testType )
    {
        for( int scale = 1; scale < 10000; scale*= 10)
        {
            hkVector4 v[3];
            v[1].set(0,0,0);
            v[0].set(hkReal(scale),0,0);
            v[2] = startPos[testType];
            v[2](0) *= scale;

            const int end = 1;
            const int ntest = 1000;
            for( int i = 0; i < 1000; ++i )
            {
                v[2](2) = (i*end)/hkReal(ntest);

                bool isDegenerate = hkpTriangleUtil::isDegenerate(v[0],v[1],v[2]);
                if( isDegenerate == false )
                {
                    {
                        hkpCollideTriangleUtil::ClosestPointTriangleCache cache;
                        hkpCollideTriangleUtil::setupClosestPointTriangleCache(v, cache);

                        //HK_TEST2( setupFailed==false, "test " << testType << " scale " << scale << " iteration " << i << " deg " << isDegenerate << " fail " << setupFailed );
                    }
                }
            }
        }
    }

    return 0;
}

HK_TEST_REGISTER(degenerate_triangles, "Fast", "Physics2012/Test/UnitTest/Collide/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
