// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// This checks the sphere-triangle agent, both the linearCast() and getPenetrations() methods.
#include <Physics2012/Collide/hkpCollide.h>


#include <Common/Base/UnitTest/hkUnitTest.h>

#include <Physics2012/Dynamics/Entity/hkpRigidBody.h>

#include <Physics2012/Collide/Shape/Convex/Box/hkpBoxShape.h>

#include <Physics2012/Collide/Agent/ConvexAgent/BoxBox/hkpBoxBoxAgent.h>
#include <Physics2012/Collide/Agent/ConvexAgent/Gjk/hkpGskBaseAgent.h>
#include <Physics2012/Collide/Agent/hkpCollisionInput.h>
#include <Physics2012/Collide/Query/Collector/PointCollector/hkpClosestCdPointCollector.h>

#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>


static void HK_CALL testClosestPointWithBigDistance()
{
    //
    //  Create two boxes
    //
    hkMotionState msA;
    hkMotionState msB;

    hkVector4 extents; extents.set(1,1,1);

    hkpBoxShape shapeA( extents );
    hkpBoxShape shapeB( extents );

    hkpCollidable bodyA( &shapeA, &msA, 0 );
    hkpCollidable bodyB( &shapeB, &msB, 0 );
    {
        msA.getTransform().setIdentity();

        msB.getTransform().setIdentity();

        msB.getTransform().getTranslation().set( .0f, .0f, 10.0f );
    }

    //
    //  Query the system several times
    //
    hkPseudoRandomGenerator random(50);
    for (int i = 0; i < 100; i++)
    {
        hkpCollisionInput input;
        input.m_tolerance = 10.f;
        random.getRandomRotation( msB.getTransform().getRotation() );

        hkpClosestCdPointCollector collector;
        hkpBoxBoxAgent::staticGetClosestPoints( bodyA, bodyB, input, collector );
        if ( !collector.hasHit() )
        {
            HK_TEST( collector.hasHit() );
        }
    }
}

static void HK_CALL testGskOnVerySmallBoxes()
{
    //
    //  Create two boxes
    //
    hkMotionState msA;
    hkMotionState msB;

    const hkReal edgeLen = 0.001f;
    hkVector4 extents; extents.setZero(); extents.setXYZ(edgeLen);
    hkpBoxShape shapeA( extents );
    hkpBoxShape shapeB( extents );

    hkpCollidable bodyA( &shapeA, &msA, 0 );
    hkpCollidable bodyB( &shapeB, &msB, 0 );
    {
        msA.getTransform().setIdentity();

        msB.getTransform().setIdentity();

        msB.getTransform().getTranslation().set( .0f, .0f, 2.0f * edgeLen );
    }

    //
    //  Query the system several times
    //
    hkPseudoRandomGenerator random(50);
    for (int i = 0; i < 100; i++)
    {
        hkpCollisionInput input;
        input.m_tolerance = 10.f;
        random.getRandomRotation( msB.getTransform().getRotation() );

        hkpClosestCdPointCollector collector;
        hkpGskBaseAgent::staticGetClosestPoints( bodyA, bodyB, input, collector );
        if ( !collector.hasHit() )
        {
            HK_TEST( collector.hasHit() );
        }
        else
        {
            const hkContactPoint& cp = collector.getHitContact();
            if ( cp.getNormal()(2) > 0.0f )
            {
                HK_TEST( cp.getNormal()(2) < 0.0f );
            }
        }
    }
}


    // Check various configurations, both penetrating and non-penetrating.
int BoxBoxTest()
{
    testClosestPointWithBigDistance();
    testGskOnVerySmallBoxes();
    return 0;
}

HK_TEST_REGISTER(BoxBoxTest, "Fast", "Physics2012/Test/UnitTest/Collide/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
