// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Physics2012/Collide/hkpCollide.h>
#include <Common/Base/UnitTest/hkUnitTest.h>
#include <Physics2012/Collide/Agent3/Machine/Midphase/hkpBlockList.h>

#define NUM_ELEMENTS_TO_ADD 1000
// These need to add up to NUM_ELEMENTS_TO_ADD
#define FIRST_BATCH 128
#define SECOND_BATCH 0
#define THIRD_BATCH 384
#define FOURTH_BATCH 488

HK_COMPILE_TIME_ASSERT( FIRST_BATCH + SECOND_BATCH + THIRD_BATCH + FOURTH_BATCH == NUM_ELEMENTS_TO_ADD );

template<typename T, int BLOCK_SIZE>
void testNextBatch( typename hkpBlockList<T, BLOCK_SIZE>::BatchConsumer& consumer, int numElements, int& currentCount )
{
    consumer.setNumElements( numElements );
    int lastCount = currentCount;
    T* t;
    int batchSize;
    while ( ( batchSize = consumer.accessBatch( t ) ) > 0 )
    {
        for ( int j = 0; j < batchSize; ++j )
        {
            HK_TEST( t[j].m_val == currentCount + j );
        }
        currentCount += batchSize;
    }

    HK_TEST( currentCount - lastCount == numElements );
}

template<typename T, int BLOCK_SIZE>
void block_list_test_batches()
{
    hkpBlockList<T, BLOCK_SIZE> blockList;

    {
        typename hkpBlockList<T, BLOCK_SIZE>::BatchWriter writer;
        writer.setToStartOfList( &blockList );

        T source[NUM_ELEMENTS_TO_ADD];
        for ( int i = 0; i < NUM_ELEMENTS_TO_ADD; ++i )
        {
            source[i].m_val = i;
        }

        writer.writeBatch( &source[0], FIRST_BATCH );
        writer.writeBatch( &source[FIRST_BATCH], SECOND_BATCH );
        writer.writeBatch( &source[FIRST_BATCH + SECOND_BATCH], THIRD_BATCH );
        writer.writeBatch( &source[FIRST_BATCH + SECOND_BATCH + THIRD_BATCH], FOURTH_BATCH );

        writer.finalize();
    }

#if defined(HK_DEBUG)
    HK_TEST( blockList.getTotalNumElems() == NUM_ELEMENTS_TO_ADD );
#endif

    {
        typename hkpBlockList<T, BLOCK_SIZE>::BatchConsumer consumer;
        consumer.setToStartOfList( &blockList );
        int count = 0;
        testNextBatch<T, BLOCK_SIZE>( consumer, FIRST_BATCH, count );
        testNextBatch<T, BLOCK_SIZE>( consumer, SECOND_BATCH, count );
        testNextBatch<T, BLOCK_SIZE>( consumer, THIRD_BATCH, count );
        testNextBatch<T, BLOCK_SIZE>( consumer, FOURTH_BATCH, count );

        consumer.finalize();
    }

#if defined(HK_DEBUG)
    blockList.checkEmpty();
#endif
}

struct HK_EXPORT_COMMON UnalignedTestStructure
{
    int m_val;
};

struct HK_EXPORT_COMMON AlignedTestStructure
{
    HK_ALIGN16( int m_val );
};

int fixed_size_block_list_main()
{
    block_list_test_batches<UnalignedTestStructure, 512>();
    block_list_test_batches<UnalignedTestStructure, 128>();

    block_list_test_batches<AlignedTestStructure, 512>();
    block_list_test_batches<AlignedTestStructure, 128>();

    return 0;
}

HK_TEST_REGISTER(fixed_size_block_list_main, "Fast", "Physics2012/Test/UnitTest/Collide/", __FILE__     );

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
