// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

/// Attributes of the buffer used in getChildShape.
enum hkpBufferSize
{
#if !defined(HK_PLATFORM_HAS_SPU)
    HK_SHAPE_BUFFER_SIZE = 512
#else
    HK_SHAPE_BUFFER_SIZE = 256
#endif
};

/// A buffer type, allocated locally on the stack by calling functions,
/// to be passed to getChildShape.
struct HK_EXPORT_PHYSICS_2012 hkpShapeBufferStorage
{
    char m_storage[HK_SHAPE_BUFFER_SIZE];

    // Previously hkpShapeBuffer was a character array, this allows it to be
    // implicitly cast to a pointer

    template<typename T>
    operator T*() { return reinterpret_cast<T*>(m_storage); }
};

// Some compilers need a struct to perform the alignment correctly
typedef HK_ALIGN_REAL(hkpShapeBufferStorage) hkpShapeBuffer;

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
