// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Math/Vector/hkFourTransposedPoints.h>

class hkpRayShapeCollectionFilter;


    /// This is the input structure you need to fill out in order to call any hkpShape::castRay() function
struct HK_EXPORT_PHYSICS_2012 hkpShapeRayBundleCastInput
{
    HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpShapeRayBundleCastInput );

        /// The constructor initializes the filter pointer to HK_NULL, which means that no shape collection filtering
        /// will be performed by default.
    inline hkpShapeRayBundleCastInput();

        /// The start positions of 4 rays transposed
    hkFourTransposedPoints m_from;

        /// The end positions of 4 rays transposed
    hkFourTransposedPoints m_to;

        /// Filter information associated with this ray.
        /// You only need to set this if you supply a filter (by setting the m_rayShapeCollectionFilter) which
        /// accesses this value. For example, the supplied filter, hkpGroupFilter, uses this value, so if you use
        /// this the hkpGroupFilter as the m_rayShapeCollectionFilter you must set this value.
    hkUint32 m_filterInfo;

    /// User defined data
    hkUlong m_userData;

        /// This is the filter which will be used to decide whether to hit or not hit.
        /// Note: this variable will normally be set automatically by the engine if you
        /// call hkpWorld::castRay / hkpAabbPhantom::castRay
    const hkpRayShapeCollectionFilter* m_rayShapeCollectionFilter;

};

void HK_CALL hkBundleRays( const hkpShapeRayCastInput rays[4], hkpShapeRayBundleCastInput& bundleOut );
void HK_CALL hkUnBundleRays(const hkpShapeRayBundleCastInput& bundleIn, hkpShapeRayCastInput rays[4]);

#include <Physics2012/Collide/Shape/Query/hkpShapeRayBundleCastInput.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
