// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

struct hkpShapeRayCastInput;
class hkpShapeCollection;
class hkpShape;



    /// This filter is called for every new child-shape of a hkpShapeCollection to be considered for ray-casting against a given ray.
class HK_EXPORT_PHYSICS_2012 hkpRayShapeCollectionFilter
{
    //+hk.MemoryTracker(ignore=True)
    public:
        HK_DECLARE_CLASS(hkpRayShapeCollectionFilter, ReflectVirtualBase);

            /// Return true if you want the child shape to be considered for ray-casting.
            /// Return false if the ray should not hit the child shape
            ///
            /// "aInput" is the initial input for the ray cast.
            /// "bContainer" is the shape container.
            /// "bKey" is the key for the child shape in bContainer being considered for filtering.
            /// You can get the child shape itself by calling bContainer->getChildShape( bKey, buffer );
        virtual hkBool isCollisionEnabled( const hkpShapeRayCastInput& aInput, const HK_SHAPE_CONTAINER& bContainer, hkpShapeKey bKey ) const = 0;


            /// Virtual destructor for derived objects
        virtual ~hkpRayShapeCollectionFilter() { }

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
