// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline const hkpShape* hkpTransformShape::getChildShape() const
{
#if defined(HK_PLATFORM_SPU)
    // fetch child shape if it is not yet present in spu's local shape buffer
    // (if m_childShapeSize == 0 the child shape already follows this shape consecutively in memory, otherwise we need to dma it in right after this shape)
    const hkpShape* ret = this + 1;

    if ( m_childShapeSize > 0 )
    {
        getChildShapeFromPpu();
    }

    HKP_PATCH_CONST_SHAPE_VTABLE( ret );
    return ret;
#else
    return m_childShape.getChild();
#endif
}

inline const hkTransform& hkpTransformShape::getTransform() const
{
    return m_transform;
}

inline const hkQuaternion& hkpTransformShape::getRotation() const
{
    return m_rotation;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
