// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>
#include <Physics2012/Collide/Shape/hkpShapeContainer.h>




    /// An hkpTransformShape contains an hkpShape and an additional transform for that shape.
    /// This is useful, for instance, if you want to position non-convex child shapes correctly
    /// when constructing a compound shape.
    /// You should avoid using a transform shape as the root shape of a rigid body.
class HK_EXPORT_PHYSICS_2012 hkpTransformShape : public hkpShape
{
    public:

        HK_DECLARE_REFLECTION();
        HK_DECLARE_CLASS_ALLOCATOR( HK_MEMORY_CLASS_SHAPE );
        HKCD_DECLARE_SHAPE_TYPE( hkcdShapeType::TRANSFORM );

    public:

            /// Empty constructor, to be called by the shape vtable util on SPU
        HK_INLINE hkpTransformShape() {}

            /// Constructs a new transform shape.
            /// This adds a reference to the child shape.
        hkpTransformShape( const hkpShape* childShape, const hkTransform& transform );
        void afterReflectNew();

    public:

            /// Get the child shape.
        inline const hkpShape* getChildShape() const;

            /// Gets the transform from the child shape's space to this transform shape's local space.
        inline const hkTransform& getTransform() const;

            /// Gets the rotation part of the transform as a quaternion
        inline const hkQuaternion& getRotation() const;

            /// Sets the current transform.
            /// Don't do this once the shape is added to a world
            /// as the agents may have cached data dependent on it.
        void setTransform( const hkTransform& transform );

    public:

            // hkpShapeBase interface implementation.
        virtual void getAabb( const hkTransform& localToWorld, hkReal tolerance, hkAabb& out ) const;

            // hkpShapeBase interface implementation.
        virtual hkBool castRay( const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& results ) const;

            // hkpShapeBase interface implementation.
        virtual void castRayWithCollector( const hkpShapeRayCastInput& input, const hkpCdBody& cdBody, hkpRayHitCollector& collector ) const;

#if !defined(HK_PLATFORM_SPU)
            /// hkpShape interface implementation.
        virtual hkReal getMaximumProjection( const hkVector4& direction ) const;

            /// hkpShape interface implementation.
        virtual const hkpShapeContainer* getContainer() const;

        virtual int calcSizeForSpu( const CalcSizeForSpuInput& input, int spuBufferSizeLeft ) const;
#endif

        void getChildShapeFromPpu() const;
        // HAVOK 2010.2 MODIFIED CODE - STL 2009/10/29 - Allow access to child shape.
        //
        // ORIGINAL:
        // ---------
        //
        //protected:
        //
        //	class hkpSingleShapeContainer m_childShape;
        //
        // NEW:
        // ----
        //

        class hkpSingleShapeContainer m_childShape;

protected:
    //
    // HAVOK 2010.2 MODIFIED CODE - STL 2009/10/29 - Allow access to child shape.
            // 0 if the child shape is following this hkpConvexTransformShape consecutively in memory, the size of the child shape otherwise
        mutable int m_childShapeSize; // +nosave

        hkQuaternion m_rotation;
        hkTransform m_transform;
};

#include <Physics2012/Collide/Shape/Misc/Transform/hkpTransformShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
