// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>



class hkpCollidable;
struct hkpCollisionInput;


    /// This shape allows you to create "phantom" shapes, which have no physical effect in a scene but which can trigger events
    /// when other shapes come close. This shape is typically the child shape of a hkpBvShape,
    /// where the bounding volume of the hkpBvShape is the boundary used for the phantom.
class HK_EXPORT_PHYSICS_2012 hkpPhantomCallbackShape : public hkpShape
{
    public:

        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();
        HKCD_DECLARE_SHAPE_TYPE( hkcdShapeType::PHANTOM_CALLBACK );

    public:

            /// Constructor
        hkpPhantomCallbackShape()
        :   hkpShape( HKCD_SHAPE_TYPE_FROM_CLASS(hkpPhantomCallbackShape) )
        {}

#if !defined(HK_PLATFORM_SPU)
        void afterReflectNew();
#endif

    public:

            /// This callback is called when the phantom shape starts intersecting with another shape.
        virtual void phantomEnterEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl,   const hkpCollisionInput& env ) = 0;

            /// This callback is called when the phantom shape stops intersecting with another shape.
        virtual void phantomLeaveEvent( const hkpCollidable* phantomColl, const hkpCollidable* otherColl ) = 0;

    public:

            /// hkpShapeBase interface implementation. Note that phantom shapes are most usually used in combination with an hkpBvShape,
            /// so getAabb() never gets called. However, if you are using the phantom shape directly with the broadphase, you need to
            /// implement this function. The default implementation returns an AABB with no volume.
        virtual void getAabb(const hkTransform& localToWorld, hkReal tolerance, hkAabb& out) const;

            /// hkpShapeBase interface implementation. Always returns false
        virtual hkBool castRay( const hkpShapeRayCastInput& input, hkpShapeRayCastOutput& results ) const;

            // hkpShapeBase interface implementation
        virtual void castRayWithCollector( const hkpShapeRayCastInput& input, const hkpCdBody& cdBody, hkpRayHitCollector& collector ) const;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
