// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/hkpShape.h>

class hkSphere;

#define HK_GET_COLLISION_SPHERE_BUFFER_SIZE 64

    /// This interface produces a set of spheres that represent a very simplified version of the objects surface.
    /// Note: This interface's function is used by hkpHeightFieldShape implementations
class HK_EXPORT_PHYSICS_2012 hkpSphereRepShape : public hkpShape
{
    public:

        HK_DECLARE_CLASS( hkpSphereRepShape, New, Reflect);
        HKCD_DECLARE_SHAPE_TYPE(hkcdShapeType::SPHERE_REP);

    public:

            /// Empty constructor, to be called by the shape vtable util on SPU
        HK_INLINE hkpSphereRepShape() {}

            /// Constructor
        hkpSphereRepShape(ShapeType type)
        :   hkpShape(type)
        {}

#ifndef HK_PLATFORM_SPU
        void afterReflectNew()
        {
            setType(HKCD_SHAPE_TYPE_FROM_CLASS(hkpSphereRepShape));
        }
#endif
};

#include <Physics2012/Collide/Shape/HeightField/hkpSphereRepShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
