// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/HeightField/SampledHeightField/hkpSampledHeightFieldShape.h>
#include <Physics2012/Collide/Shape/HeightField/SampledHeightField/hkpSampledHeightFieldBaseCinfo.h>



/// A heightfield shape which stores the heights as an array of hkReals.
/// This class is most useful for debug snapshots in the same way as hkpStorageMeshShape.
/// Normally the heightfield data would be stored in a more memory efficient manner,
/// possibly shared with other components.
///
/// hkpStorageSampledHeightFieldShape is also used as a simple heightfield implementation on the SPU
class HK_EXPORT_PHYSICS_2012 hkpStorageSampledHeightFieldShape : public hkpSampledHeightFieldShape
{
    //+hk.ReflectedFile("hkpHeightField")
    public:

        HK_DECLARE_CLASS(hkpStorageSampledHeightFieldShape, New, Reflect, BypassCtor);

        hkpStorageSampledHeightFieldShape( const hkpSampledHeightFieldShape* hf );

        hkpStorageSampledHeightFieldShape( const hkpSampledHeightFieldBaseCinfo& info, hkArray<hkReal>& samples );

        HK_INLINE HKP_SHAPE_VIRTUAL hkReal getHeightAtImpl( HKP_SHAPE_VIRTUAL_THIS int x, int z ) HKP_SHAPE_VIRTUAL_CONST;

        HK_INLINE HKP_SHAPE_VIRTUAL hkBool getTriangleFlipImpl(HKP_SHAPE_VIRTUAL_THIS2) HKP_SHAPE_VIRTUAL_CONST;

        virtual void collideSpheres( const CollideSpheresInput& input, SphereCollisionOutput* outputArray) const;

#if !defined(HK_PLATFORM_SPU)
        void afterReflectNew()
        {
            m_heightfieldType = hkpSampledHeightFieldShape::HEIGHTFIELD_STORAGE;
        }

            /// hkpShape Interface
        virtual int calcSizeForSpu(const CalcSizeForSpuInput& input, int spuBufferSizeLeft) const;
#endif

    public:

        hkArray<hkReal> m_storage;
        hkBool m_triangleFlip;
};

#include <Physics2012/Collide/Shape/HeightField/StorageSampledHeightField/hkpStorageSampledHeightFieldShape.inl>

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
