// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : PHYSICS_2012
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// hkpSampledHeightFieldBaseCinfo meta information
/// The information needed to construct an hkSampledHeightFieldBase
class HK_EXPORT_PHYSICS_2012 hkpSampledHeightFieldBaseCinfo
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpSampledHeightFieldBaseCinfo );

            /// Default constructor
        hkpSampledHeightFieldBaseCinfo()
        {
            m_scale.set(1.0f, 1.0f, 1.0f);
            m_xRes = 2;
            m_zRes = 2;
            m_minHeight = 0.0f;
            m_maxHeight = -1.0f;
            m_useProjectionBasedHeight = false;
        }

        //
        // Members
        //
    public:

            /// The heightfield scale in x,y,z.
        hkVector4 m_scale;

            /// The resolution along x.
        hkInt32 m_xRes;

            /// The resolution along z (y up).
        hkInt32 m_zRes;

            /// The minimum height returned by the heightfield.
        hkReal m_minHeight;

            /// The maximum height returned by the heightfield. Note: If m_maxHeight is set to
            /// less than m_minHeight than constructor will scan the entire heightfield)
        hkReal m_maxHeight;

            /// The method used to calculated the height.
            /// By default (m_useProjectionBasedHeight = false) the height will be measured by
            /// projecting the vertex down onto the heightfield and using this pure vertical
            /// distance. This results in a smooth distance function but fails for steep slopes. As
            /// a result objects hitting a steep slope can get extra energy.
            /// By setting m_useProjectionBasedHeight to true, the real distance between the point
            /// and the triangle will be measured. This allows for steep
            /// slopes but results in a non continuous distance function, which will cause objects
            /// to jitter when they cross triangle boundaries, especially objects with a big radius
            /// like spheres.
        hkBool m_useProjectionBasedHeight;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
