// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Deprecated/Mesh/hkpMeshShape.h>




/// DEPRECATED. This shape will be removed in future releases of Havok Physics.
///
/// A mesh shape which stores its data. See also hkpSimpleMeshShape.
/// NOTE: it is very error prone to modify the subparts of an
/// hkpStorageMeshShape directly because the subpart pointers need to
/// be updated if the storage is resized.
/// This class is primarily used internally, for taking snapshots of a world containing hkMeshShapes.
/// All hkMeshShapes are converted into hkStorageMeshShapes for serialization.
class HK_EXPORT_PHYSICS_2012 hkpStorageMeshShape : public hkpMeshShape
{
    //+hk.ReflectedFile("hkpMeshShape")
    public:
        HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE);
        HK_DECLARE_REFLECTION();

            /// Default constructor.
            /// The data for this shape is public, so simply fill in the
            /// member data after construction.
        hkpStorageMeshShape( hkReal radius = hkConvexShapeDefaultRadius, int numBitsForSubpartIndex = 12 );

            /// Copy the mesh into this mesh.
        hkpStorageMeshShape( const hkpMeshShape* mesh );

            ///
        ~hkpStorageMeshShape()
        {
            for( int i = 0; i < m_storage.getSize(); ++i )
            {
                m_storage[i]->removeReference();
            }
        }

            /// Add the part and copy its data internally.
            /// NOTE: it is not recommended to modify a subpart after it
            /// has been added.
            /// NOTE: materials are not copied.
        virtual void addSubpart( const Subpart& part );

    public:

        void afterReflectNew();

        struct SubpartStorage : public hkReferencedObject
        {
            public:

                HK_DECLARE_REFLECTION();
                HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_SHAPE);

                SubpartStorage() {}
                virtual ~SubpartStorage() {}

                hkArray<hkReal> m_vertices;
                hkArray<hkUint16> m_indices16;
                hkArray<hkUint32> m_indices32;
                hkArray<hkUint8> m_materialIndices; //materialIndices8
                hkArray<hkUint32> m_materials;
                hkArray<hkUint16> m_materialIndices16;
        };

    protected:

        hkArray<struct SubpartStorage*> m_storage;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
