// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Internal/Collide/ConvexPieceMesh/hkpConvexPieceStreamData.h>

#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>

HK_EXPORT_PHYSICS_2012 extern hkReal hkConvexShapeDefaultRadius;


/// DEPRECATED. This shape will be removed in future releases of Havok Physics.
class HK_EXPORT_PHYSICS_2012 hkpConvexPieceMeshShape: public hkpShapeCollection
{
    //+hk.ReflectedFile("hkpConvexPieceMeshShape")
    public:

        HK_DECLARE_CLASS(hkpConvexPieceMeshShape, New, Reflect, BypassCtor);
        HK_RECORD_ATTR(hk::IncludeInMgd(false));
        HKCD_DECLARE_SHAPE_TYPE(hkcdShapeType::COLLECTION);

            /// Constructs a new hkpConvexPieceMeshShape.
            ///
            /// The inputMesh should be any hkpShapeCollection that returns hkpTriangleShape children.
            ///
            /// The convexPieceStream must be created by the hkpConvexPieceMeshBuilder::convexifyLandscape method.
        hkpConvexPieceMeshShape( const hkpShapeCollection* inputMesh, const hkpConvexPieceStreamData* convexPieceStream, hkReal radius = hkConvexShapeDefaultRadius );

#if !defined(HK_PLATFORM_SPU)
        void afterReflectNew();
#endif

        ~hkpConvexPieceMeshShape()
        {
            if(m_displayMesh) m_displayMesh->removeReference();
            if(m_convexPieceStream) m_convexPieceStream->removeReference();
        }

        //
        // hkpShape Collection interface
        //

            /// hkpShapeCollection interface implementation.
            /// Gets the first child shape key.
        virtual hkpShapeKey getFirstKey() const;

            /// This function implements hkpShapeCollection::getNextKey.
            /// Gets the next child shape key.
        virtual hkpShapeKey getNextKey( hkpShapeKey oldKey ) const;


            /// hkpShapeCollection interface implementation.
        const hkpShape* getChildShape( hkpShapeKey key, hkpShapeBuffer& buffer ) const;

            /// Tests if the vertex given by vertexId is set in the vertex bitstream
            /// of stream.
        const hkBool vertexIsSet( const hkUint32* stream, int vertexId ) const;

            /// hkpShapeCollection interface implementation
        virtual hkUint32 getCollisionFilterInfo( hkpShapeKey key ) const;

        //
        // hkpShape interface
        //

            /// Used to pre-calculate the AABB for this shape.
        void calcAabb();

            /// hkpShape interface implementation.
            /// A precise but not very fast implementation of getting an AABB.
        void getAabb(const hkTransform& localToWorld, hkReal tolerance, class hkAabb& out) const;

        //
        // Statistics retrieval interface
        //

            /// Contains statistical information about the structure of the convex piece mesh.
        struct Stats
        {
            HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkpConvexPieceMeshShape::Stats );

                /// The total number of triangles in the mesh.
            int m_numTriangles;

                /// The total number of convex pieces in the mesh.
            int m_numConvexPieces;

                /// The average number of triangles per convex piece.
                /// This should be used as the metric to determine how
                /// effective the builder algorithm is - the higher this value
                /// is the better.
            hkReal m_avgNumTriangles;

                /// The maximum number of triangles in any single convex piece.
            int m_maxTrianglesPerConvexPiece;

            Stats() : m_numTriangles(0), m_numConvexPieces(0), m_avgNumTriangles(0), m_maxTrianglesPerConvexPiece(0) {}
        };

            /// Fills statsOut to contains info about this mesh shape.
        void getStats( Stats& statsOut );

    public:

            /// The mesh, divided into convex pieces which are then stored in a
            /// bit stream.
        const hkpConvexPieceStreamData* m_convexPieceStream;

            /// The underlying meshShape
        const hkpShapeCollection* m_displayMesh;

    protected:
            /// The radius used in the construction of the convex pieces.
            /// This can only be set on construction.
        hkReal m_radius;

};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
