// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : ALL
// PRODUCT      : PHYSICS_2012
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Physics2012/Collide/Shape/Compound/Collection/hkpShapeCollection.h>
#include <Physics2012/Collide/Shape/Compound/Tree/hkpBvTreeShape.h>
#include <Common/Base/Types/Geometry/hkGeometry.h>
#include <Physics2012/Collide/Shape/Compound/Collection/SimpleMesh/hkpSimpleMeshShape.h>


class hkTjunctionDetector
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_UTILITIES, hkTjunctionDetector);

            /// Proximity info enum
        enum ProximityInfoEnum
        {
            NEAR_NONE = 0,
            NEAR_EDGE0,
            NEAR_EDGE1,
            NEAR_EDGE2,
            NEAR_FACE
        };

            /// Proximity info struct
        struct ProximityInfo 
        {
                /// The neighboring vertex
            hkVector4 m_vertex;

                /// The index of the vertex
            int m_index;

                /// The key of the face (index in the triangle list)
            hkpShapeKey m_key;

                /// The type of proximity
            ProximityInfoEnum m_type;

                /// The corners of the triangle
            hkVector4 m_v0, m_v1, m_v2;
        };

            /// Detects the T-junctions and welded vertices for a given geometry
        static void HK_CALL detect( const hkGeometry& geometry, hkArray<ProximityInfo>& Tjunctions, hkArray<hkVector4>& weldedVertices,
            hkReal junctionTolerance = 1e-4f, hkReal weldTolerance = 1e-3f );

            /// Decides whether a vertex is close to a triangle or not (within a given tolerance)
        static ProximityInfoEnum HK_CALL vertexCloseToTriangle( const hkVector4& vertex, const hkVector4& triA,
            const hkVector4& triB, const hkVector4& triC, hkReal tolerance );

            /// Detects the T-junctions and welded vertices for a given simple mesh shape and a bounding volume tree wrapping it
        static void HK_CALL detect( hkpSimpleMeshShape* mesh, const hkpBvTreeShape* bvTree, hkArray<ProximityInfo>& Tjunctions,
            hkArray<hkVector4>& weldedVertices, hkReal junctionTolerance = 1e-4f, hkReal weldTolerance = 1e-3f );

        static hkpSimpleMeshShape* HK_CALL createSimpleMeshFromGeometry( const hkGeometry& geometry );
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
